/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.test;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class RemoveHsfBeansPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final String HSF_NAME = "com.taobao.hsf.app.spring.util.HSFSpringProviderBean";
    private ApplicationContext applicationContext;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DefaultListableBeanFactory beanDefinitionRegistry = null;
        if (this.applicationContext instanceof GenericApplicationContext) {
            beanDefinitionRegistry = (DefaultListableBeanFactory)((GenericApplicationContext)this.applicationContext).getBeanFactory();
        } else if (this.applicationContext instanceof ClassPathXmlApplicationContext) {
            beanDefinitionRegistry = (DefaultListableBeanFactory)((ClassPathXmlApplicationContext)this.applicationContext).getBeanFactory();
        }
        if (beanDefinitionRegistry != null) {
            String[] beanDefinitionNames;
            for (String name : beanDefinitionNames = beanDefinitionRegistry.getBeanDefinitionNames()) {
                BeanDefinition beanDefinition = beanDefinitionRegistry.getBeanDefinition(name);
                if (beanDefinition.getBeanClassName() == null || !beanDefinition.getBeanClassName().equals(HSF_NAME)) continue;
                beanDefinitionRegistry.removeBeanDefinition(name);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

