package com.ohaotian.plugin.validation.constraints;

import com.ohaotian.plugin.validation.enums.CaseMode;
import com.ohaotian.plugin.validation.internal.constraintvalidators.CheckCaseValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * <hr>
 *
 * @author TheWk
 * @version 1.0.0
 * <pre>
 * =========================== Logs =========================== <br>
 * 1.0.0(2018-03-08 17:37) TheWk 创建 <br>
 * =========================== Logs =========================== <br>
 * </pre>
 */
@Retention(RUNTIME)
@Documented
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
@Constraint(validatedBy = {CheckCaseValidator.class})
public @interface CheckCase {

    String message() default "";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    CaseMode value();

    /**
     * Defines several {@link CheckCase} annotations on the same element.
     *
     * @see CheckCase
     */
    @Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
    @Retention(RUNTIME)
    @Documented
    @interface List {

        CheckCase[] value();
    }
}
