package com.ohaotian.plugin.validation.internal.constraintvalidators;

import com.ohaotian.plugin.validation.constraints.EndsWith;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author TheWk
 * @version 1.0.0
 * <pre>
 * =========================== Logs =========================== <br>
 * 1.0.0(2017-10-30 15:45) TheWk 创建 <br>
 * =========================== Logs =========================== <br>
 * </pre>
 */
public class EndsWithValidator implements ConstraintValidator<EndsWith, CharSequence> {

    private String ends;

    @Override
    public void initialize(EndsWith constraintAnnotation) {
        this.ends = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null || value.length() == 0) {
            return true;
        }
        return value.toString().endsWith(ends);
    }
}
