/*
 * 作者 www.TheWk.cn.vc 开发环境 Windows7 64位 Eclipse4.4.1 JDK1.8.0_05 开发日期 2015年7月20日
 */
package com.ohaotian.plugin.validation.constraints;

import com.ohaotian.plugin.validation.constant.ValidationConstant;

import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.constraints.Pattern;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * 请输入大写英文字符
 *
 * @author TheWk
 * @version 1.0.0
 * <pre>
 * =========================== Logs ===========================
 * 1.0.0(2017-10-21) TheWk 创建
 * =========================== Logs ===========================
 * </pre>
 */
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
@Retention(RUNTIME)
@Documented
@Constraint(validatedBy = {})
@ReportAsSingleViolation // 标识为复合注解
@Pattern(regexp = ValidationConstant.UPPERCASE)
public @interface Uppercase {

    String message() default "{com.ohaotian.base.validation.constraints.Uppercase.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    /**
     * Defines several {@link Uppercase} annotations on the same element.
     *
     * @see Uppercase
     */
    @Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
    @Retention(RUNTIME)
    @Documented
    @interface List {

        Uppercase[] value();
    }
}
