package com.ohaotian.plugin.web.config;

import com.ohaotian.plugin.web.filter.SensitiveWordFilter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import java.util.Arrays;

/**
 * @author liuzhenhua
 * @description: 敏感词过滤器
 * @date 2021/12/22 09:36
 */
@Configuration
public class SensitiveWordConfig {

    @Value("${tydic.security.sensitiveWord.enabled}")
    private Boolean sensitiveWordEnabled;

    @Value("${tydic.security.sensitiveWord.urlPatterns}")
    private String sensitiveWordUrlPatterns;

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        if (sensitiveWordEnabled){
            SensitiveWordFilter sensitiveWordFilter = new SensitiveWordFilter();
            /**
             * 敏感词过滤器
             */
            filterRegistrationBean.setFilter(sensitiveWordFilter);

            if (!StringUtils.isEmpty(sensitiveWordUrlPatterns)){
                /**
                 * 设置过滤器要拦截请求
                 */
                String[] urls = sensitiveWordUrlPatterns.split(",");
                filterRegistrationBean.setUrlPatterns(Arrays.asList(urls));
            }
        }

        return filterRegistrationBean;
    }
}