package com.ohaotian.plugin.web.filter;

import com.ohaotian.plugin.web.cache.Cache;
import com.ohaotian.plugin.web.utils.SensitiveWordUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author liuzhenhua
 * @description: 敏感词过滤器
 * @date 2021/12/21 10:46
 */
@Slf4j
public class SensitiveWordFilter implements Filter {

    /**
     * 服务启动,系统初始化敏感词方法
     * @param filterConfig
     * @throws ServletException
     */
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        /**
         * 缓存词库
         */
        SensitiveWordUtil.readWordsFile();
        log.info("应用启动，SensitiveWordFilter过滤器初始化敏感词库完成.");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        ParamsRequestWrapper paramsRequestWrapper = new ParamsRequestWrapper(httpRequest);

        Map<String, String[]> parameterMap = new HashMap<>(paramsRequestWrapper.getParameterMap());

        if (parameterMap != null && parameterMap.size() > 0){
            /**
             * 值类型参数修改
             */
            paramsRequestWrapper.modifyParameters(parameterMap);
        }

        chain.doFilter(paramsRequestWrapper, response);
    }

    @Override
    public void destroy() {
        Cache.remove(SensitiveWordUtil.WORDS);
    }
}
