/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.web.config;

import com.ohaotian.plugin.web.filter.SensitiveWordFilter;
import java.util.Arrays;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SensitiveWordConfig {
    @Value(value="${tydic.security.sensitiveWord.enabled}")
    private Boolean sensitiveWordEnabled;
    @Value(value="${tydic.security.sensitiveWord.urlPatterns}")
    private String sensitiveWordUrlPatterns;

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        if (this.sensitiveWordEnabled.booleanValue()) {
            SensitiveWordFilter sensitiveWordFilter = new SensitiveWordFilter();
            filterRegistrationBean.setFilter((Filter)sensitiveWordFilter);
            if (!StringUtils.isEmpty((CharSequence)this.sensitiveWordUrlPatterns)) {
                String[] urls = this.sensitiveWordUrlPatterns.split(",");
                filterRegistrationBean.setUrlPatterns(Arrays.asList(urls));
            }
        }
        return filterRegistrationBean;
    }
}

