/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.web.filter;

import com.ohaotian.plugin.web.filter.ParamsServletInputStream;
import com.ohaotian.plugin.web.utils.SensitiveWordUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ParamsRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private static final String ENCODING = "UTF-8";
    private static final String CLASSTYPE = "java.lang.String";

    public ParamsRequestWrapper(HttpServletRequest request) {
        super(request);
        this.parameterMap = request.getParameterMap();
    }

    public void modifyParameters(Map<String, String[]> parameterMap) {
        Set<String> set = parameterMap.keySet();
        for (String key : set) {
            String[] values = parameterMap.get(key);
            values[0] = SensitiveWordUtil.replaceSensitiveWord(values[0]);
            parameterMap.put(key, values);
        }
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> vector = new Vector<String>(this.parameterMap.keySet());
        return vector.elements();
    }

    public String getParameter(String name) {
        if (this.parameterMap.containsKey(name)) {
            String[] results = this.parameterMap.get(name);
            return results[0];
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, String[]> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public ServletInputStream getInputStream() throws IOException {
        ServletInputStream stream = super.getInputStream();
        if (!super.getHeader("Content-Type").equalsIgnoreCase("application/json")) {
            return stream;
        }
        String json = IOUtils.toString((InputStream)stream, (String)ENCODING);
        if (StringUtils.isBlank((CharSequence)json)) {
            return stream;
        }
        System.out.println("\u8f6c\u5316\u524d\u53c2\u6570\uff1a" + json);
        String result = SensitiveWordUtil.replaceSensitiveWord(json, 2);
        System.out.println("\u8f6c\u5316\u524d\u53c2\u6570\uff1a" + result);
        ByteArrayInputStream bis = new ByteArrayInputStream(result.getBytes(ENCODING));
        return new ParamsServletInputStream(bis);
    }
}

