/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.web.filter;

import com.ohaotian.plugin.web.cache.Cache;
import com.ohaotian.plugin.web.filter.ParamsRequestWrapper;
import com.ohaotian.plugin.web.utils.SensitiveWordUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveWordFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SensitiveWordFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        SensitiveWordUtil.readWordsFile();
        log.info("\u5e94\u7528\u542f\u52a8\uff0cSensitiveWordFilter\u8fc7\u6ee4\u5668\u521d\u59cb\u5316\u654f\u611f\u8bcd\u5e93\u5b8c\u6210.");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ParamsRequestWrapper paramsRequestWrapper = new ParamsRequestWrapper(httpRequest);
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(paramsRequestWrapper.getParameterMap());
        if (parameterMap != null && parameterMap.size() > 0) {
            paramsRequestWrapper.modifyParameters(parameterMap);
        }
        chain.doFilter((ServletRequest)paramsRequestWrapper, response);
    }

    public void destroy() {
        Cache.remove("WORDS");
    }
}

