/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.web.utils;

import com.ohaotian.plugin.web.cache.Cache;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

public class SensitiveWordUtil {
    private static final Logger log = LoggerFactory.getLogger(SensitiveWordUtil.class);
    public static final String WORDS = "WORDS";
    public static final int MinMatchTYpe = 1;
    public static final int MaxMatchType = 2;
    private static final char maskChar = '*';
    private static HashMap sensitiveWordMap;

    public static synchronized void init(List<String> sensitiveWordSet) {
        SensitiveWordUtil.initSensitiveWordMap(sensitiveWordSet);
    }

    private static void initSensitiveWordMap(List<String> sensitiveWordSet) {
        sensitiveWordMap = new HashMap(sensitiveWordSet.size());
        for (String key : sensitiveWordSet) {
            Map<Object, Object> nowMap = sensitiveWordMap;
            for (int i = 0; i < key.length(); ++i) {
                char keyChar = key.charAt(i);
                Object wordMap = nowMap.get(Character.valueOf(keyChar));
                if (wordMap != null) {
                    nowMap = (Map)wordMap;
                } else {
                    HashMap<String, String> newWorMap = new HashMap<String, String>();
                    newWorMap.put("isEnd", "0");
                    nowMap.put(Character.valueOf(keyChar), newWorMap);
                    nowMap = newWorMap;
                }
                if (i != key.length() - 1) continue;
                nowMap.put("isEnd", "1");
            }
        }
    }

    public static boolean contains(String txt, int matchType) {
        boolean flag = false;
        for (int i = 0; i < txt.length(); ++i) {
            int matchFlag = SensitiveWordUtil.checkSensitiveWord(txt, i, matchType);
            if (matchFlag <= 0) continue;
            flag = true;
        }
        return flag;
    }

    public static boolean contains(String txt) {
        return SensitiveWordUtil.contains(txt, 2);
    }

    public static List<String> getSensitiveWord(String txt, int matchType) {
        ArrayList<String> sensitiveWordList = new ArrayList<String>();
        for (int i = 0; i < txt.length(); ++i) {
            int length = SensitiveWordUtil.checkSensitiveWord(txt, i, matchType);
            if (length <= 0) continue;
            sensitiveWordList.add(txt.substring(i, i + length));
            i = i + length - 1;
        }
        return sensitiveWordList;
    }

    public static List<String> getSensitiveWord(String txt) {
        return SensitiveWordUtil.getSensitiveWord(txt, 2);
    }

    public static String replaceSensitiveWord(String txt) {
        return SensitiveWordUtil.replaceSensitiveWord(txt, '*', 2);
    }

    public static String replaceSensitiveWord(String txt, char maskChar) {
        return SensitiveWordUtil.replaceSensitiveWord(txt, maskChar, 2);
    }

    public static String replaceSensitiveWord(String txt, int matchType) {
        return SensitiveWordUtil.replaceSensitiveWord(txt, '*', matchType);
    }

    public static String replaceSensitiveWord(String txt, char maskChar, int matchType) {
        List<String> words = Cache.get(WORDS);
        if (CollectionUtils.isEmpty(words)) {
            words = SensitiveWordUtil.readWordsFile();
            Cache.put(WORDS, words);
        }
        if (CollectionUtils.isEmpty(words)) {
            return txt;
        }
        if (sensitiveWordMap == null) {
            SensitiveWordUtil.init(words);
        }
        String resultTxt = txt;
        List<String> listWords = SensitiveWordUtil.getSensitiveWord(txt, matchType);
        for (String word : listWords) {
            resultTxt = resultTxt.replaceAll(word, SensitiveWordUtil.getReplaceChars(maskChar, word.length()));
        }
        return resultTxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readWordsFile() {
        ArrayList<String> listWords = new ArrayList<String>();
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            Resource resource = new DefaultResourceLoader().getResource("classpath:shield_word.txt");
            inputStream = resource.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(inputStreamReader);
            String word = "";
            while (StringUtils.isNotBlank((CharSequence)(word = bufferedReader.readLine()))) {
                listWords.add(word);
            }
            if (listWords.size() > 0) {
                Cache.put(WORDS, listWords);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u654f\u611f\u8bcd\u6c47\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                log.error("\u8bfb\u53d6\u654f\u611f\u8bcd\u6c47\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            }
        }
        return listWords;
    }

    private static String getReplaceChars(char maskChar, int length) {
        StringBuilder resultReplace = new StringBuilder(String.valueOf(maskChar));
        for (int i = 1; i < length; ++i) {
            resultReplace.append(maskChar);
        }
        return resultReplace.toString();
    }

    private static int checkSensitiveWord(String txt, int beginIndex, int matchType) {
        char word;
        boolean flag = false;
        int matchFlag = 0;
        Map nowMap = sensitiveWordMap;
        for (int i = beginIndex; i < txt.length() && (nowMap = (Map)nowMap.get(Character.valueOf(word = txt.charAt(i)))) != null; ++i) {
            ++matchFlag;
            if (!"1".equals(nowMap.get("isEnd"))) continue;
            flag = true;
            if (1 == matchType) break;
        }
        if (matchFlag < 2 || !flag) {
            matchFlag = 0;
        }
        return matchFlag;
    }

    public static void main(String[] args) {
        String str = "\u6211\u4eec\u4f1f\u5927\u7684\u9886\u8896\u6bdb\u6cfd\u4e1c\u521b\u7acb\u65b0\u4e2d\u56fd";
        System.out.println("--->\u66ff\u6362\u524d:" + str);
        System.out.println("--->\u66ff\u6362\u540e:" + SensitiveWordUtil.replaceSensitiveWord(str));
    }
}

