/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.tapclient.factory;

import com.ohaotian.plugin.tapclient.proxy.TapClientInvocationHandler;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class TapClientFactoryBean<T>
implements FactoryBean<T>,
InitializingBean,
ApplicationContextAware {
    private Class<T> type;
    private String name;
    private ApplicationContext applicationContext;
    @Autowired
    private TapClientInvocationHandler tapClientInvocationHandler;

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public T getObject() throws Exception {
        return (T)this.tapClientInvocationHandler.bind(this.getType());
    }

    public Class<T> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.name, (String)"Name must be set");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TapClientFactoryBean)) {
            return false;
        }
        TapClientFactoryBean that = (TapClientFactoryBean)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.applicationContext, that.applicationContext);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.applicationContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TapClientFactoryBean{");
        sb.append("type=").append(this.type);
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

