/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.tapclient.proxy;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.tapclient.annotation.TapMethod;
import com.ohaotian.plugin.tapclient.config.TapProperties;
import com.ohaotian.plugin.tapclient.dto.UniBss;
import com.ohaotian.plugin.tapclient.dto.UniBssBody;
import com.ohaotian.plugin.tapclient.dto.UniBssHead;
import com.ohaotian.plugin.tapclient.dto.builder.UniBssHeadBuilder;
import com.ohaotian.plugin.tapclient.exception.TapCallEx;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class TapCaller {
    @Autowired
    private RestTemplate restTemplate;
    private TapProperties props;

    public TapCaller(TapProperties tapProperties) {
        this.props = tapProperties;
    }

    public TapProperties getProps() {
        return this.props;
    }

    public void setProps(TapProperties props) {
        this.props = props;
    }

    private <T> T callOuter(TapMethod tapMethod, Object[] args, Class<T> rspType) {
        if (args.length != 1) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        UniBssHead head = UniBssHeadBuilder.anUniBssHead().withAppId(this.getProps().getAppId()).withTimestamp(new Date()).genTransId().genToken(this.getProps().getAppSecret()).build();
        UniBss req = new UniBss();
        UniBssBody body = new UniBssBody();
        body.setData((tapMethod.serviceCode() + "_REQ").toUpperCase(), args[0]);
        req.setHead(head);
        req.setBody(body);
        JSONObject resp = (JSONObject)this.restTemplate.postForObject(this.getProps().getBaseUrl() + tapMethod.path(), (Object)req, JSONObject.class, new Object[0]);
        JSONObject respHead = resp.getJSONObject("UNI_BSS_HEAD");
        if (!"0000".equals(respHead.getString("RESP_CODE"))) {
            throw new TapCallEx(respHead.getString("RESP_CODE"), respHead.getString("RESP_DESC"));
        }
        JSONObject respBody = resp.getJSONObject("UNI_BSS_BODY").getJSONObject((tapMethod.serviceCode() + "_RSP").toUpperCase());
        return (T)JSONObject.parseObject((String)respBody.toJSONString(), rspType);
    }

    private <T> T callInner(TapMethod tapMethod, Object[] args, Class<T> rspType) {
        if (args.length != 1) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        JSONObject resp = (JSONObject)this.restTemplate.postForObject(this.getProps().getBaseUrl() + tapMethod.path(), args[0], JSONObject.class, new Object[0]);
        JSONObject respHead = resp.getJSONObject("UNI_BSS_HEAD");
        if (!"0000".equals(respHead.getString("RESP_CODE"))) {
            throw new TapCallEx(respHead.getString("RESP_CODE"), respHead.getString("RESP_DESC"));
        }
        JSONObject respBody = resp.getJSONObject("UNI_BSS_BODY");
        return (T)JSONObject.parseObject((String)respBody.toJSONString(), rspType);
    }

    public <T> T call(TapMethod tapMethod, Object[] args, Class<T> rspType) {
        if (tapMethod.isOuter()) {
            return this.callOuter(tapMethod, args, rspType);
        }
        return this.callInner(tapMethod, args, rspType);
    }
}

