/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.tapclient.dto.builder;

import com.ohaotian.plugin.tapclient.dto.UniBssHead;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.util.DigestUtils;

public final class UniBssHeadBuilder {
    private String appId;
    private Date timestamp;
    private String transId;
    private String token;
    private List<Object> reserved;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    private static final SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    private UniBssHeadBuilder() {
    }

    public static UniBssHeadBuilder anUniBssHead() {
        return new UniBssHeadBuilder();
    }

    public UniBssHeadBuilder withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public UniBssHeadBuilder withTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public UniBssHeadBuilder withTransId(String transId) {
        this.transId = transId;
        return this;
    }

    public UniBssHeadBuilder withReserved(List<Object> reserved) {
        this.reserved = reserved;
        return this;
    }

    public UniBssHeadBuilder genTransId() {
        this.transId = sdf1.format(this.timestamp) + UniBssHeadBuilder.getRandomNumberInRange(100000, 999999);
        return this;
    }

    public UniBssHeadBuilder genToken(String appSecret) {
        String signStr = "APP_ID" + this.appId + "TIMESTAMP" + sdf.format(this.timestamp) + "TRANS_ID" + this.transId + appSecret;
        this.token = DigestUtils.md5DigestAsHex((byte[])signStr.getBytes());
        return this;
    }

    private static int getRandomNumberInRange(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    public UniBssHead build() {
        UniBssHead uniBssHead = new UniBssHead();
        uniBssHead.setAppId(this.appId);
        uniBssHead.setTimestamp(this.timestamp);
        uniBssHead.setTransId(this.transId);
        uniBssHead.setReserved(this.reserved);
        uniBssHead.setToken(this.token);
        return uniBssHead;
    }
}

