/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.tapclient.proxy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.tapclient.annotation.TapMethod;
import com.ohaotian.plugin.tapclient.config.TapProperties;
import com.ohaotian.plugin.tapclient.dto.UniBss;
import com.ohaotian.plugin.tapclient.dto.UniBssBody;
import com.ohaotian.plugin.tapclient.dto.UniBssHead;
import com.ohaotian.plugin.tapclient.dto.builder.UniBssHeadBuilder;
import com.ohaotian.plugin.tapclient.exception.TapCallEx;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class TapCaller {
    @Autowired
    private RestTemplate restTemplate;
    private TapProperties props;

    public TapCaller(TapProperties tapProperties) {
        this.props = tapProperties;
    }

    public TapProperties getProps() {
        return this.props;
    }

    public void setProps(TapProperties props) {
        this.props = props;
    }

    private JSONObject callTransInner(TapMethod tapMethod, Object[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        UniBssHead head = UniBssHeadBuilder.anUniBssHead().withAppId(this.getProps().getAppId(tapMethod.propKey())).withTimestamp(new Date()).genTransId().genToken(this.getProps().getAppSecret(tapMethod.propKey())).build();
        UniBss req = new UniBss();
        UniBssBody body = new UniBssBody();
        body.setData((tapMethod.serviceCode() + "_REQ").toUpperCase(), args[0]);
        req.setHead(head);
        req.setBody(body);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept-Encoding", "");
        HttpEntity request = new HttpEntity((Object)req, (MultiValueMap)headers);
        JSONObject resp = (JSONObject)this.restTemplate.postForObject(this.getProps().getBaseUrl(tapMethod.propKey()) + tapMethod.path(), (Object)request, JSONObject.class, new Object[0]);
        JSONObject respHead = resp.getJSONObject("UNI_BSS_HEAD");
        String respCode = respHead.getString("RESP_CODE");
        if (!this.props.getSuccessCode().contains(respCode)) {
            throw new TapCallEx(respCode, respHead.getString("RESP_DESC"));
        }
        JSONObject uniBssBody = resp.getJSONObject("UNI_BSS_BODY");
        return uniBssBody;
    }

    private <T> T callTrans(TapMethod tapMethod, Object[] args, Class<T> rspType) {
        if (args.length != 1) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept-Encoding", "");
        HttpEntity request = new HttpEntity(args[0], (MultiValueMap)headers);
        return (T)this.restTemplate.postForObject(this.getProps().getBaseUrl(tapMethod.propKey()) + tapMethod.path(), (Object)request, rspType, new Object[0]);
    }

    public <T> T call(TapMethod tapMethod, Object[] args, Class<T> rspType) {
        if (tapMethod.isTrans()) {
            return this.callTrans(tapMethod, args, rspType);
        }
        JSONObject uniBssBody = this.callTransInner(tapMethod, args);
        JSONObject respBody = uniBssBody.getJSONObject((tapMethod.serviceCode() + "_RSP").toUpperCase());
        return (T)JSONObject.parseObject((String)respBody.toJSONString(), rspType);
    }

    public <T> List<T> callList(TapMethod tapMethod, Object[] args, Class<T> rspType) {
        JSONObject uniBssBody = this.callTransInner(tapMethod, args);
        JSONArray respBody = uniBssBody.getJSONArray((tapMethod.serviceCode() + "_RSP").toUpperCase());
        return (List)JSON.parseObject((String)respBody.toJSONString(), (TypeReference)new TypeReference<List<T>>(new Type[]{rspType}){}, (Feature[])new Feature[0]);
    }
}

