/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.project.config;

import com.google.gson.Gson;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.project.config.BodyReaderHttpServletRequestWrapper;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;

public abstract class MyAbstractTicketValidationFilter
extends AbstractCasFilter {
    private Long userId;
    private TicketValidator ticketValidator;
    private boolean redirectAfterValidation = true;
    private boolean exceptionOnValidationFailure = false;
    private boolean useSession = true;

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    protected MyAbstractTicketValidationFilter(Protocol protocol) {
        super(protocol);
    }

    protected TicketValidator getTicketValidator(FilterConfig filterConfig) {
        return this.ticketValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getSSLConfig() {
        Properties properties = new Properties();
        String fileName = this.getString(ConfigurationKeys.SSL_CONFIG_FILE);
        if (fileName != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(fileName);
                properties.load(fis);
                this.logger.trace("Loaded {} entries from {}", (Object)properties.size(), (Object)fileName);
            }
            catch (IOException ioe) {
                try {
                    this.logger.error(ioe.getMessage(), (Throwable)ioe);
                }
                catch (Throwable throwable) {
                    CommonUtils.closeQuietly(fis);
                    throw throwable;
                }
                CommonUtils.closeQuietly((Closeable)fis);
            }
            CommonUtils.closeQuietly((Closeable)fis);
        }
        return properties;
    }

    protected HostnameVerifier getHostnameVerifier() {
        Class className = this.getClass(ConfigurationKeys.HOSTNAME_VERIFIER);
        String config = this.getString(ConfigurationKeys.HOSTNAME_VERIFIER_CONFIG);
        if (className != null) {
            if (config != null) {
                return (HostnameVerifier)ReflectUtils.newInstance((Class)className, (Object[])new Object[]{config});
            }
            return (HostnameVerifier)ReflectUtils.newInstance((Class)className, (Object[])new Object[0]);
        }
        return null;
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        this.setExceptionOnValidationFailure(this.getBoolean(ConfigurationKeys.EXCEPTION_ON_VALIDATION_FAILURE));
        this.setRedirectAfterValidation(this.getBoolean(ConfigurationKeys.REDIRECT_AFTER_VALIDATION));
        this.setUseSession(this.getBoolean(ConfigurationKeys.USE_SESSION));
        if (!this.useSession && this.redirectAfterValidation) {
            this.logger.warn("redirectAfterValidation parameter may not be true when useSession parameter is false. Resetting it to false in order to prevent infinite redirects.");
            this.setRedirectAfterValidation(false);
        }
        this.setTicketValidator(this.getTicketValidator(filterConfig));
        super.initInternal(filterConfig);
    }

    public void init() {
        super.init();
        CommonUtils.assertNotNull((Object)this.ticketValidator, (String)"ticketValidator cannot be null.");
    }

    protected boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        return true;
    }

    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
    }

    protected void onFailedValidation(HttpServletRequest request, HttpServletResponse response) {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (request.getHeader("appid") != null && request.getHeader("tenantid") != null && request.getHeader("token") != null && request.getHeader("clusterid") != null) {
            Long tenantId = Long.valueOf(request.getHeader("tenantid"));
            BodyReaderHttpServletRequestWrapper myRequestWrapper = new BodyReaderHttpServletRequestWrapper(request);
            Map map = (Map)new Gson().fromJson((Reader)myRequestWrapper.getReader(), Map.class);
            String selectUserId = null;
            selectUserId = map != null ? (String)map.get("userId") : myRequestWrapper.getParameter("userId");
            if (StrUtil.isNullOrEmpty((String)selectUserId)) {
                UserHolder.setUserId((String)this.userId.toString());
            } else {
                UserHolder.setUserId((String)selectUserId);
            }
            filterChain.doFilter((ServletRequest)myRequestWrapper, (ServletResponse)response);
        } else {
            if (!this.preFilter(servletRequest, servletResponse, filterChain)) {
                return;
            }
            String ticket = this.retrieveTicketFromRequest(request);
            if (CommonUtils.isNotBlank((String)ticket)) {
                this.logger.debug("Attempting to validate ticket: {}", (Object)ticket);
                try {
                    Assertion assertion = this.ticketValidator.validate(ticket, this.constructServiceUrl(request, response));
                    this.logger.debug("Successfully authenticated user: {}", (Object)assertion.getPrincipal().getName());
                    request.setAttribute("_const_cas_assertion_", (Object)assertion);
                    if (this.useSession) {
                        request.getSession().setAttribute("_const_cas_assertion_", (Object)assertion);
                    }
                    this.onSuccessfulValidation(request, response, assertion);
                    if (this.redirectAfterValidation) {
                        this.logger.debug("Redirecting after successful ticket validation.");
                        response.sendRedirect(this.constructServiceUrl(request, response));
                        return;
                    }
                }
                catch (TicketValidationException e) {
                    this.logger.debug(e.getMessage(), (Throwable)e);
                    this.onFailedValidation(request, response);
                    if (this.exceptionOnValidationFailure) {
                        throw new ServletException((Throwable)e);
                    }
                    response.sendError(403, e.getMessage());
                    return;
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public final void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public final void setRedirectAfterValidation(boolean redirectAfterValidation) {
        this.redirectAfterValidation = redirectAfterValidation;
    }

    public final void setExceptionOnValidationFailure(boolean exceptionOnValidationFailure) {
        this.exceptionOnValidationFailure = exceptionOnValidationFailure;
    }

    public final void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }
}

