/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.project.config;

import com.ohaotian.portalcommon.api.AppSecretAPI;
import com.ohaotian.portalcommon.model.bo.AppSecretBO;
import com.ohaotian.portalcommon.util.MD5TokenUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.authentication.AuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.ContainsPatternUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultGatewayResolverImpl;
import org.jasig.cas.client.authentication.ExactUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.GatewayResolver;
import org.jasig.cas.client.authentication.RegexUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.UrlPatternMatcherStrategy;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;

public class MyAuthroityFilter
extends AbstractCasFilter {
    private AppSecretAPI appSecretAPI;
    private String casServerLoginUrl;
    private boolean renew = false;
    private boolean gateway = false;
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();
    private AuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();
    private UrlPatternMatcherStrategy ignoreUrlPatternMatcherStrategyClass = null;
    private static final Map<String, Class<? extends UrlPatternMatcherStrategy>> PATTERN_MATCHER_TYPES = new HashMap<String, Class<? extends UrlPatternMatcherStrategy>>();

    public MyAuthroityFilter() {
        this(Protocol.CAS2);
    }

    public MyAuthroityFilter(AppSecretAPI appSecretAPI) {
        this(Protocol.CAS2);
        this.appSecretAPI = appSecretAPI;
    }

    protected MyAuthroityFilter(Protocol protocol) {
        super(protocol);
    }

    public MyAuthroityFilter(Protocol protocol, AppSecretAPI appSecretAPI) {
        super(protocol);
        this.appSecretAPI = appSecretAPI;
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        if (!this.isIgnoreInitConfiguration()) {
            Class authenticationRedirectStrategyClass;
            Class gatewayStorageClass;
            super.initInternal(filterConfig);
            this.setCasServerLoginUrl(this.getString(ConfigurationKeys.CAS_SERVER_LOGIN_URL));
            this.setRenew(this.getBoolean(ConfigurationKeys.RENEW));
            this.setGateway(this.getBoolean(ConfigurationKeys.GATEWAY));
            String ignorePattern = this.getString(ConfigurationKeys.IGNORE_PATTERN);
            String ignoreUrlPatternType = this.getString(ConfigurationKeys.IGNORE_URL_PATTERN_TYPE);
            if (ignorePattern != null) {
                Class<? extends UrlPatternMatcherStrategy> ignoreUrlMatcherClass = PATTERN_MATCHER_TYPES.get(ignoreUrlPatternType);
                if (ignoreUrlMatcherClass != null) {
                    this.ignoreUrlPatternMatcherStrategyClass = (UrlPatternMatcherStrategy)ReflectUtils.newInstance((String)ignoreUrlMatcherClass.getName(), (Object[])new Object[0]);
                } else {
                    try {
                        this.logger.trace("Assuming {} is a qualified class name...", (Object)ignoreUrlPatternType);
                        this.ignoreUrlPatternMatcherStrategyClass = (UrlPatternMatcherStrategy)ReflectUtils.newInstance((String)ignoreUrlPatternType, (Object[])new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error("Could not instantiate class [{}]", (Object)ignoreUrlPatternType, (Object)e);
                    }
                }
                if (this.ignoreUrlPatternMatcherStrategyClass != null) {
                    this.ignoreUrlPatternMatcherStrategyClass.setPattern(ignorePattern);
                }
            }
            if ((gatewayStorageClass = this.getClass(ConfigurationKeys.GATEWAY_STORAGE_CLASS)) != null) {
                this.setGatewayStorage((GatewayResolver)ReflectUtils.newInstance((Class)gatewayStorageClass, (Object[])new Object[0]));
            }
            if ((authenticationRedirectStrategyClass = this.getClass(ConfigurationKeys.AUTHENTICATION_REDIRECT_STRATEGY_CLASS)) != null) {
                this.authenticationRedirectStrategy = (AuthenticationRedirectStrategy)ReflectUtils.newInstance((Class)authenticationRedirectStrategyClass, (Object[])new Object[0]);
            }
        }
    }

    public void init() {
        super.init();
        CommonUtils.assertNotNull((Object)this.casServerLoginUrl, (String)"casServerLoginUrl cannot be null.");
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block14: {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            Enumeration headerNames = request.getHeaderNames();
            if (this.isRequestUrlExcluded(request)) {
                this.logger.debug("Request is ignored.");
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (!(StrUtil.isNullOrEmpty((String)request.getHeader("appid")) || StrUtil.isNullOrEmpty((String)request.getHeader("tenantid")) || StrUtil.isNullOrEmpty((String)request.getHeader("token")) || StrUtil.isNullOrEmpty((String)request.getHeader("clusterid")))) {
                String modifiedServiceUrl;
                Long tenantId = Long.valueOf(request.getHeader("tenantid"));
                Long clusterId = Long.valueOf(request.getHeader("clusterid"));
                String appCode = request.getHeader("appid");
                String token = request.getHeader("token");
                String serviceUrl = this.constructServiceUrl(request, response);
                this.logger.debug("no ticket and no assertion found");
                if (this.gateway) {
                    this.logger.debug("setting gateway attribute in session");
                    modifiedServiceUrl = this.gatewayStorage.storeGatewayInformation(request, serviceUrl);
                } else {
                    modifiedServiceUrl = serviceUrl;
                }
                this.logger.debug("Constructed service url: {}", (Object)modifiedServiceUrl);
                String urlToRedirectTo = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.getProtocol().getServiceParameterName(), (String)modifiedServiceUrl, (boolean)this.renew, (boolean)this.gateway);
                AppSecretBO appSecretPO = this.appSecretAPI.selectByAppConf(appCode, tenantId, clusterId);
                if (appSecretPO != null) {
                    try {
                        String appSecret = appSecretPO.getAppSecret();
                        StringBuffer sb = new StringBuffer("APPID=");
                        sb.append(appCode).append("&").append("APPSECRET=").append(appSecret);
                        String md5Token = MD5TokenUtil.md5((String)sb.toString());
                        if (md5Token.equals(token)) {
                            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                            break block14;
                        }
                        this.authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo);
                    }
                    catch (NoSuchAlgorithmException e) {
                        this.logger.error("md5\u52a0\u5bc6\u5931\u8d25");
                    }
                } else {
                    this.authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo);
                }
            } else {
                String modifiedServiceUrl;
                boolean wasGatewayed;
                Assertion assertion;
                HttpSession session = request.getSession(false);
                Assertion assertion2 = assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
                if (assertion != null) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                String serviceUrl = this.constructServiceUrl(request, response);
                String ticket = this.retrieveTicketFromRequest(request);
                boolean bl = wasGatewayed = this.gateway && this.gatewayStorage.hasGatewayedAlready(request, serviceUrl);
                if (CommonUtils.isNotBlank((String)ticket) || wasGatewayed) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                this.logger.debug("no ticket and no assertion found");
                if (this.gateway) {
                    this.logger.debug("setting gateway attribute in session");
                    modifiedServiceUrl = this.gatewayStorage.storeGatewayInformation(request, serviceUrl);
                } else {
                    modifiedServiceUrl = serviceUrl;
                }
                this.logger.debug("Constructed service url: {}", (Object)modifiedServiceUrl);
                String urlToRedirectTo = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.getProtocol().getServiceParameterName(), (String)modifiedServiceUrl, (boolean)this.renew, (boolean)this.gateway);
                this.logger.debug("redirecting to \"{}\"", (Object)urlToRedirectTo);
                this.authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo);
            }
        }
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public final void setGatewayStorage(GatewayResolver gatewayStorage) {
        this.gatewayStorage = gatewayStorage;
    }

    private boolean isRequestUrlExcluded(HttpServletRequest request) {
        if (this.ignoreUrlPatternMatcherStrategyClass == null) {
            return false;
        }
        StringBuffer urlBuffer = request.getRequestURL();
        if (request.getQueryString() != null) {
            urlBuffer.append("?").append(request.getQueryString());
        }
        String requestUri = urlBuffer.toString();
        return this.ignoreUrlPatternMatcherStrategyClass.matches(requestUri);
    }

    static {
        PATTERN_MATCHER_TYPES.put("CONTAINS", ContainsPatternUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("REGEX", RegexUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("EXACT", ExactUrlPatternMatcherStrategy.class);
    }
}

