/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.project.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.project.mapper.SjzAbilityMapper;
import com.ohaotian.project.mapper.SjzClusterMapper;
import com.ohaotian.project.model.bo.QryAbilityListReqBO;
import com.ohaotian.project.model.bo.QryAbilityListRspBO;
import com.ohaotian.project.model.po.AbilityPO;
import com.ohaotian.project.model.po.AbilityProvideDeployPO;
import com.ohaotian.project.model.po.ClusterPO;
import com.ohaotian.project.service.SjzAbilityListService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SjzAbilityListServiceImpl
implements SjzAbilityListService {
    @Resource
    private SjzAbilityMapper sjzAbilityMapper;
    @Resource
    private SjzClusterMapper sjzClusterMapper;
    @Resource
    private AuthorityService authorityService;

    @Override
    public RspBO<RspPage<QryAbilityListRspBO>> queryAbilityListTmp(QryAbilityListReqBO qryAbilityListReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        StringBuilder order = new StringBuilder();
        if (qryAbilityListReqBO.getSortName() != null) {
            order.append(qryAbilityListReqBO.getSortName());
            if (qryAbilityListReqBO.getSortOrder() != null) {
                order.append(" ");
                order.append(qryAbilityListReqBO.getSortOrder());
            }
        } else {
            order.append("a.").append("UPDATE_TIME").append(" DESC");
        }
        Page page = PageHelper.startPage((int)qryAbilityListReqBO.getPageNo(), (int)qryAbilityListReqBO.getPageSize(), (String)order.toString());
        qryAbilityListReqBO.setHirerId(tenantId);
        ArrayList<QryAbilityListRspBO> qryAbilityListRspBOList = new ArrayList<QryAbilityListRspBO>();
        List<AbilityPO> abilityPOIdList = this.sjzAbilityMapper.queryAbilityListTmp(qryAbilityListReqBO);
        for (AbilityPO abilityPOId : abilityPOIdList) {
            AbilityPO abilityPO = this.sjzAbilityMapper.queryAbilityWithProvideDeployByAbilityId(abilityPOId.getAbilityId());
            if (null == abilityPO) continue;
            QryAbilityListRspBO qryAbilityListRspBO = (QryAbilityListRspBO)BeanMapper.map((Object)abilityPO, QryAbilityListRspBO.class);
            qryAbilityListRspBO.setAllClusterName(this.getAllClusterName(abilityPO.getAbilityProvideDeployPOList()));
            qryAbilityListRspBOList.add(qryAbilityListRspBO);
        }
        RspPage rspPage = new RspPage(Integer.valueOf(qryAbilityListReqBO.getPageSize()), Integer.valueOf(qryAbilityListReqBO.getPageNo()), qryAbilityListRspBOList, Long.valueOf(page.getTotal()));
        RspBO rspBO = RspBO.success((Object)rspPage);
        return rspBO;
    }

    @Override
    public RspBO<RspPage<QryAbilityListRspBO>> queryAbilityListUnsubscribe(QryAbilityListReqBO qryAbilityListReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        StringBuilder order = new StringBuilder();
        if (qryAbilityListReqBO.getSortName() != null) {
            order.append(qryAbilityListReqBO.getSortName());
            if (qryAbilityListReqBO.getSortOrder() != null) {
                order.append(" ");
                order.append(qryAbilityListReqBO.getSortOrder());
            }
        } else {
            order.append("a.").append("UPDATE_TIME").append(" DESC");
        }
        Page page = PageHelper.startPage((int)qryAbilityListReqBO.getPageNo(), (int)qryAbilityListReqBO.getPageSize(), (String)order.toString());
        qryAbilityListReqBO.setHirerId(tenantId);
        ArrayList<QryAbilityListRspBO> qryAbilityListRspBOList = new ArrayList<QryAbilityListRspBO>();
        List<AbilityPO> abilityPOIdList = this.sjzAbilityMapper.queryAbilityListUnsubscribe(qryAbilityListReqBO);
        for (AbilityPO abilityPOId : abilityPOIdList) {
            AbilityPO abilityPO = this.sjzAbilityMapper.queryAbilityWithProvideDeployByAbilityIdNew(abilityPOId.getAbilityId());
            if (null == abilityPO) continue;
            QryAbilityListRspBO qryAbilityListRspBO = (QryAbilityListRspBO)BeanMapper.map((Object)abilityPO, QryAbilityListRspBO.class);
            qryAbilityListRspBO.setAllClusterName(this.getAllClusterName(abilityPO.getAbilityProvideDeployPOList()));
            qryAbilityListRspBOList.add(qryAbilityListRspBO);
        }
        RspPage rspPage = new RspPage(Integer.valueOf(qryAbilityListReqBO.getPageSize()), Integer.valueOf(qryAbilityListReqBO.getPageNo()), qryAbilityListRspBOList, Long.valueOf(page.getTotal()));
        RspBO rspBO = RspBO.success((Object)rspPage);
        return rspBO;
    }

    private String getAllClusterName(List<AbilityProvideDeployPO> abilityProvideDeployPOList) {
        StringBuilder sb = new StringBuilder();
        List clusterPOS = abilityProvideDeployPOList.stream().map(po -> this.sjzClusterMapper.queryByClusterId(po.getClusterId())).distinct().collect(Collectors.toList());
        for (int i = 0; i < clusterPOS.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            ClusterPO clusterPO = (ClusterPO)clusterPOS.get(i);
            sb.append(clusterPO.getClusterName());
        }
        return sb.toString();
    }
}

