/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.project.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeMap;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeValue;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.project.mapper.SjzAppRegionMapper;
import com.ohaotian.project.mapper.SjzClusterMapper;
import com.ohaotian.project.model.bo.AppRegionRepBO;
import com.ohaotian.project.model.bo.AppRegionRspBO;
import com.ohaotian.project.model.po.ClusterPO;
import com.ohaotian.project.service.SjzAppRegionService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SjzAppRegionServiceImpl
implements SjzAppRegionService {
    private Logger log = LogManager.getLogger(SjzAppRegionServiceImpl.class);
    @Resource
    SjzAppRegionMapper sjzAppRegionMapper;
    @Resource
    SjzClusterMapper sjzClusterMapper;

    @Override
    public RspBO qryAppRegionList(AppRegionRepBO appRegionRepBO) {
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)appRegionRepBO.getRegionCode())) {
            appRegionRepBO.setRegionCode("%" + appRegionRepBO.getRegionCode() + "%");
        }
        if (!StringUtils.isEmpty((Object)appRegionRepBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)appRegionRepBO.getSortName()));
            if (!StringUtils.isEmpty((Object)appRegionRepBO.getSortOrder())) {
                order.append(" ").append(appRegionRepBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        Page page = !StringUtils.isEmpty((Object)order) ? PageHelper.startPage((int)appRegionRepBO.getPageNo(), (int)appRegionRepBO.getPageSize(), (String)order.toString()) : PageHelper.startPage((int)appRegionRepBO.getPageNo(), (int)appRegionRepBO.getPageSize());
        List<AppRegionRspBO> appRegionRspBOList = this.sjzAppRegionMapper.selectAppRegionRepBOByAppIdandCode(appRegionRepBO.getAppId(), appRegionRepBO.getRegionCode(), appRegionRepBO.getRegionName(), appRegionRepBO.getAttendStatus());
        List<AppRegionRspBO> allAppRegionRspBOList = this.sjzAppRegionMapper.selectRegionIdByappIdandCode(appRegionRepBO.getAppId(), appRegionRepBO.getRegionCode());
        appRegionRspBOList.forEach(appRegionRspBO -> {
            ArrayList clusterListName = new ArrayList();
            allAppRegionRspBOList.forEach(allAppRegionRspBO -> {
                if (allAppRegionRspBO.getRegionId().equals(appRegionRspBO.getRegionId())) {
                    ClusterPO clusterPO = this.sjzClusterMapper.queryByClusterId(allAppRegionRspBO.getClusterId());
                    clusterListName.add(clusterPO.getClusterName());
                }
            });
            appRegionRspBO.setClusterListName(org.apache.commons.lang3.StringUtils.join(clusterListName, (String)","));
            SystemCodeValue systemCode = SystemCodeMap.getSystemCode((String)"1011", (String)(appRegionRspBO.getHaddrPolicy() + ""));
            appRegionRspBO.setHaddrPolicyLabel(systemCode.getDicValue());
        });
        RspPage rspPage = new RspPage(Integer.valueOf(appRegionRepBO.getPageSize()), Integer.valueOf(appRegionRepBO.getPageNo()), appRegionRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }
}

