/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.project.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.project.mapper.SjzAppSubscribeDeployMapper;
import com.ohaotian.project.mapper.SjzClusterMapper;
import com.ohaotian.project.model.bo.QryAppSubscribeReqBO;
import com.ohaotian.project.model.bo.QryAppSubscribeRspBO;
import com.ohaotian.project.model.po.ClusterPO;
import com.ohaotian.project.service.SjzAppSubscribeService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SjzAppSubscribeServiceImpl
implements SjzAppSubscribeService {
    private static final Logger log = LogManager.getLogger(SjzAppSubscribeService.class);
    @Resource
    AuthorityService authorityService;
    @Resource
    private SjzAppSubscribeDeployMapper sjzAppSubscribeDeployMapper;
    @Resource
    private SjzClusterMapper sjzClusterMapper;

    @Override
    public RspBO<RspPage<QryAppSubscribeRspBO>> qrySubscribeList(QryAppSubscribeReqBO qryAppSubscribeReqBO) throws ZTBusinessException {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        qryAppSubscribeReqBO.setHirerId(tenantId);
        log.debug("AppSubscribeServiceImpl.qryAppSubscribeListPageByCond:{}", (Object)qryAppSubscribeReqBO);
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getAbilityName())) {
            qryAppSubscribeReqBO.setAbilityName("%" + qryAppSubscribeReqBO.getAbilityName() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getAbilityEname())) {
            qryAppSubscribeReqBO.setAbilityEname("%" + qryAppSubscribeReqBO.getAbilityEname() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getInputProtocal())) {
            qryAppSubscribeReqBO.setInputProtocal("%" + qryAppSubscribeReqBO.getInputProtocal() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getOutputProtocal())) {
            qryAppSubscribeReqBO.setOutputProtocal("%" + qryAppSubscribeReqBO.getOutputProtocal() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)qryAppSubscribeReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getSortOrder())) {
                order.append(" ").append(qryAppSubscribeReqBO.getSortOrder());
            }
        } else {
            order.append("dd.deploy_time").append(" DESC");
        }
        int pageNo = qryAppSubscribeReqBO.getPageNo();
        int pageSize = qryAppSubscribeReqBO.getPageSize();
        Page page = !StringUtils.isEmpty((Object)order) ? PageHelper.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageHelper.startPage((int)pageNo, (int)pageSize);
        List<QryAppSubscribeRspBO> appRspBOList = this.sjzAppSubscribeDeployMapper.qrySubscribeList(qryAppSubscribeReqBO);
        appRspBOList.stream().map(bo -> {
            ClusterPO clusterPO = this.sjzClusterMapper.queryByClusterId(bo.getClusterId());
            bo.setClusterName(clusterPO.getClusterName());
            return bo;
        }).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), appRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }
}

