/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.project.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeMap;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeValue;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.project.mapper.SjzAppMapper;
import com.ohaotian.project.model.bo.AppReqBO;
import com.ohaotian.project.model.bo.AppRspBO;
import com.ohaotian.project.service.SjzAppService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SjzSjzAppServiceImpl
implements SjzAppService {
    private static final Logger log = LogManager.getLogger(SjzSjzAppServiceImpl.class);
    @Resource
    private AuthorityService authorityService;
    @Resource
    private SjzAppMapper sjzAppMapper;

    @Override
    public RspBO<RspPage<AppRspBO>> qryAppListPageByCondTmp(AppReqBO appReqBO) throws ZTBusinessException {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        appReqBO.setHirerId(tenantId);
        log.debug("AppServiceImpl.qryAppListPageByCond:{}", (Object)appReqBO);
        if (!StringUtils.isEmpty((Object)appReqBO.getAppName())) {
            appReqBO.setAppName("%" + appReqBO.getAppName() + "%");
        }
        if (!StringUtils.isEmpty((Object)appReqBO.getAppCode())) {
            appReqBO.setAppCode("%" + appReqBO.getAppCode() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)appReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)appReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)appReqBO.getSortOrder())) {
                order.append(" ").append(appReqBO.getSortOrder());
            }
        } else {
            order.append("a." + SqlUtil.getDefaultOrderBy());
        }
        int pageNo = appReqBO.getPageNo();
        int pageSize = appReqBO.getPageSize();
        Page page = !StringUtils.isEmpty((Object)order) ? PageHelper.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageHelper.startPage((int)pageNo, (int)pageSize);
        List<AppRspBO> appRspBOList = this.sjzAppMapper.queryByBO(appReqBO);
        appRspBOList.stream().map(bo -> {
            SystemCodeValue attentStatus = SystemCodeMap.getSystemCode((String)"1000", (String)(bo.getAttendStatus() + ""));
            if (attentStatus != null) {
                bo.setAttendStatusName(attentStatus.getDicValue());
            }
            return bo;
        }).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), appRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }
}

