/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.security.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.application.bo.ApplicationBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserRspBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeReqBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeRspBO;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.user.bo.QueryUserByUserIdRspBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.ChangePwdByUserIdService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspMapInfoBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/auth"})
public class PermissionsController {
    private Logger logger = LoggerFactory.getLogger(PermissionsController.class);
    @Autowired
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @Autowired
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @Autowired
    private ChangePwdByUserIdService changePwdByUserIdService;

    @RequestMapping(value={"/getUserMenus"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserMenus(@RequestParam(required=false) String appCode) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            HashMap map = new HashMap();
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appCode})) {
                Map menus = user.getMenus();
                SelectByApplicationCodeReqBO selectByApplicationCodeReqBO = new SelectByApplicationCodeReqBO();
                selectByApplicationCodeReqBO.setApplicationCode(appCode);
                SelectByApplicationCodeRspBO application = this.selectByApplicationCodeBusiService.selectByApplicationCode(selectByApplicationCodeReqBO);
                map.put("menus", menus.get(appCode));
                if (application != null) {
                    map.put("appName", application.getApplicationBO().getApplicationName());
                }
            } else {
                SelectApplicationByUserReqBO applicationByUserReqBO = new SelectApplicationByUserReqBO();
                applicationByUserReqBO.setUserId(user.getUserId());
                applicationByUserReqBO.setOrgPath(user.getOrgPath());
                SelectApplicationByUserRspBO applicationByUserRspBO = this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
                List applicationBOS = applicationByUserRspBO.getApplicationBOS();
                if (applicationBOS != null && applicationBOS.size() > 0) {
                    ApplicationBO applicationBO = (ApplicationBO)applicationBOS.get(0);
                    map.put("appName", applicationBO.getApplicationName());
                    map.put("isExt", applicationBO.getIsExt());
                    appCode = applicationBO.getApplicationCode();
                    Map menus = user.getMenus();
                    map.put("menus", menus.get(appCode));
                }
            }
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/havePerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object havePerms(@RequestParam String[] authority) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (String auth : authority) {
                map.put(auth, user.hasAuthority(auth));
            }
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/getUserPerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserPerms() {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            HashSet permission = new HashSet();
            user.getPermission().forEach(perm -> permission.add(perm.getKey()));
            return permission;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/getUserInfo"})
    @BusiResponseBody
    public Object getUserInfo() {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo != null) {
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            HashMap<String, String> resMap = new HashMap<String, String>();
            resMap.put("userName", userInfo.getUsername());
            resMap.put("orgName", userInfo.getOrgName());
            resMap.put("name", userInfo.getName());
            UserIdBO user = new UserIdBO();
            user.setUserId(userInfo.getUserId());
            QueryUserByUserIdRspBO userIdRspBO = this.changePwdByUserIdService.queryUserByUserId(user);
            this.logger.debug("\u67e5\u8be2\u7528\u6237\u51fa\u53c2" + JSON.toJSONString((Object)userIdRspBO));
            if (userIdRspBO != null && "0000".equals(userIdRspBO.getRespCode())) {
                resMap.put("isModifyPwd", userIdRspBO.getIsModifyPwd());
                resMap.put("modifyPwdTitle", userIdRspBO.getModifyPwdTitle());
            }
            rspMapInfoBO.setData(resMap);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f");
    }
}

