/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.security.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.security.CustomUserDetailsService;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.SelectUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.plugin.cache.CacheTemplate;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.filter.TokenAuthenticationFilter;
import com.ohaotian.plugin.security.service.GetUserInfoByUserIdService;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
@Order(value=9999)
public class GetUserInfoByUserIdServiceImpl
implements GetUserInfoByUserIdService {
    @Autowired
    private CustomUserDetailsService userDetailsService;
    @Autowired
    private TokenAuthenticationFilter tokenAuthenticationFilter;
    @Reference(version="1.0.0", group="authority")
    private SelectUserInfoService selectUserInfoService;
    @Reference(version="1.0.0", group="authority")
    private SelectTenantByIdService selectTenantByIdService;
    @Reference(version="1.0.0", group="authority")
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    private CacheTemplate cacheTemplate = CacheTemplate.getIstance();

    @PostConstruct
    private void init() {
        this.tokenAuthenticationFilter.setGetUserInfoByTokenService((GetUserInfoByUserIdService)this);
    }

    public UserDetails getUserInfoByUserId(Long userId, String token) {
        Object o = this.cacheTemplate.get(token);
        if (o != null) {
            return (UserDetails)o;
        }
        UserInfo userInfo = this.loadUserInfo(userId);
        this.cacheTemplate.set(token, (Object)userInfo);
        return userInfo;
    }

    private UserInfo loadUserInfo(Long userId) {
        UserInfo userInfo = new UserInfo();
        SelectUserInfoReqBO userInfoReqBO = new SelectUserInfoReqBO();
        userInfoReqBO.setUserId(userId);
        SelectUserInfoRspBO rspUser = this.selectUserInfoService.selectUserInfo(userInfoReqBO);
        if (rspUser != null) {
            userInfo.setUserId(rspUser.getUserId());
            userInfo.setName(rspUser.getName());
            userInfo.setUsername(rspUser.getLoginName());
            userInfo.setOrgId(rspUser.getOrgId());
            userInfo.setCellphone(rspUser.getCellPhone());
            if (rspUser.getTenantId() != null) {
                TenantIdBO tenantIdBO = new TenantIdBO();
                tenantIdBO.setTenantId(rspUser.getTenantId());
                TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
                userInfo.setTenantId(tenantRspBO.getTenantId());
                userInfo.setTenantName(tenantRspBO.getTenantName());
            }
            if (userInfo.getOrgId() != null) {
                OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
                organisationIdReqBO.setOrganisationId(userInfo.getOrgId());
                RspOrganisationBO organisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
                if (organisationBO != null) {
                    userInfo.setOrgPath(organisationBO.getOrgTreePath());
                    userInfo.setOrgName(organisationBO.getTitle());
                }
            }
        }
        return userInfo;
    }
}

