/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.security.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ohaotian.authority.application.bo.ApplicationBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserRspBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeReqBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeRspBO;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameRspBO;
import com.ohaotian.authority.user.service.SelectUserByLoginNameService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspMapInfoBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.jwt.Jwt;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PermissionsController {
    private Logger logger = LoggerFactory.getLogger(PermissionsController.class);
    @Reference(version="1.0.0", group="authority")
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserByLoginNameService selectUserByLoginNameService;

    @RequestMapping(value={"/auth/getUserMenus"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserMenus(@RequestParam(required=false) String appCode) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            HashMap map = new HashMap();
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appCode})) {
                Map menus = user.getMenus();
                SelectByApplicationCodeReqBO selectByApplicationCodeReqBO = new SelectByApplicationCodeReqBO();
                selectByApplicationCodeReqBO.setApplicationCode(appCode);
                SelectByApplicationCodeRspBO application = this.selectByApplicationCodeBusiService.selectByApplicationCode(selectByApplicationCodeReqBO);
                map.put("menus", menus.get(appCode));
                if (application != null) {
                    map.put("appName", application.getApplicationBO().getApplicationName());
                }
            } else {
                SelectApplicationByUserReqBO applicationByUserReqBO = new SelectApplicationByUserReqBO();
                applicationByUserReqBO.setUserId(user.getUserId());
                applicationByUserReqBO.setOrgPath(user.getOrgPath());
                SelectApplicationByUserRspBO applicationByUserRspBO = this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
                List applicationBOS = applicationByUserRspBO.getApplicationBOS();
                if (applicationBOS != null && applicationBOS.size() > 0) {
                    ApplicationBO applicationBO = (ApplicationBO)applicationBOS.get(0);
                    map.put("appName", applicationBO.getApplicationName());
                    map.put("isExt", applicationBO.getIsExt());
                    appCode = applicationBO.getApplicationCode();
                    Map menus = user.getMenus();
                    map.put("menus", menus.get(appCode));
                }
            }
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/havePerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object havePerms(@RequestParam String[] authority) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (String auth : authority) {
                map.put(auth, user.hasAuthority(auth));
            }
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/getUserPerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserPerms() {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            HashSet permission = new HashSet();
            user.getPermission().forEach(perm -> permission.add(perm.getKey()));
            return permission;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/getUserInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserInfo() {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo != null) {
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            HashMap<String, String> resMap = new HashMap<String, String>();
            resMap.put("userName", userInfo.getUsername());
            resMap.put("orgName", userInfo.getOrgName());
            resMap.put("name", userInfo.getName());
            rspMapInfoBO.setData(resMap);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f");
    }

    @RequestMapping(value={"/api/token/get"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getToken(String loginName, String passWord, String appCode) {
        SelectUserByLoginNameRspBO user;
        HashMap<String, Long> payload = new HashMap<String, Long>();
        Date date = new Date();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginName}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{passWord}) && (user = this.selectUserByLoginNameService.selectUserByLoginNameService(loginName, passWord)) != null) {
            payload.put("userId", user.getUserId());
        }
        payload.put("iat", date.getTime());
        payload.put("ext", date.getTime() + 0x6DDD00L);
        String token = Jwt.createToken(payload);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25");
        }
        RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("token", token);
        rspMapInfoBO.setData(resMap);
        return rspMapInfoBO;
    }
}

