/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing;

import com.ohaotian.task.timing.utils.JsonUtil;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.concurrent.ThreadPoolExecutorFactoryBean;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;

@SpringBootApplication
@MapperScan(basePackages={"com.ohaotian.task.timing.dao"})
@ServletComponentScan(value={"com.ohaotian.task.timing.filter"})
public class TaskConfigApplication {
    public static void main(String[] args) {
        SpringApplication.run(TaskConfigApplication.class, (String[])args);
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        jsonConverter.setObjectMapper(JsonUtil.OBJECT_MAPPER);
        return jsonConverter;
    }

    @Bean
    public MethodValidationPostProcessor methodValidationPostProcessor() {
        return new MethodValidationPostProcessor();
    }

    @Bean(destroyMethod="shutdown")
    public ThreadPoolExecutorFactoryBean threadPoolExecutorFactoryBean() {
        ThreadPoolExecutorFactoryBean threadPoolExecutorFactoryBean = (ThreadPoolExecutorFactoryBean)BeanUtils.instantiateClass(ThreadPoolExecutorFactoryBean.class);
        threadPoolExecutorFactoryBean.setCorePoolSize(2);
        threadPoolExecutorFactoryBean.setMaxPoolSize(Runtime.getRuntime().availableProcessors() * 2 + 1);
        return threadPoolExecutorFactoryBean;
    }
}

