/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.aspect;

import com.alibaba.fastjson.JSON;
import com.ohaotian.task.timing.aspect.OperatorLog;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class OperatorLogAspect {
    private static final Logger log = LoggerFactory.getLogger(OperatorLogAspect.class);

    @Pointcut(value="@annotation(com.ohaotian.task.timing.aspect.OperatorLog)")
    public void operatorLog() {
    }

    @Before(value="operatorLog()")
    public void doBefore(JoinPoint joinPoint) {
        try {
            String description = OperatorLogAspect.getSystemLogDescription(joinPoint);
            log.info("============<\u6267\u884c\u5f00\u59cb>======== " + description + "\u8bf7\u6c42\u53c2\u6570" + this.getSystemParam(joinPoint) + "===========================");
        }
        catch (Exception e) {
            log.error("doBefore error {}", (Throwable)e);
        }
    }

    private String getSystemParam(JoinPoint joinPoint) {
        return JSON.toJSONString((Object)joinPoint.getArgs());
    }

    @Around(value="operatorLog()")
    public Object doSurround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object[] objects = proceedingJoinPoint.getArgs();
        String name = proceedingJoinPoint.getSignature().getName();
        long startTime = System.currentTimeMillis();
        Object result = proceedingJoinPoint.proceed();
        log.warn("\u5f53\u524d\u7c7b\uff1a{}, \u65b9\u6cd5\u540d\uff1a{}", (Object)proceedingJoinPoint.getTarget().getClass().getName(), (Object)name);
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                if (null == objects[i]) continue;
                log.warn("\u7b2c" + (i + 1) + "\u4e2a\u65b9\u6cd5\u5165\u53c2\u6570{}\uff1a <{}>", (Object)objects[i].getClass().getName(), (Object)JSON.toJSONString((Object)objects[i]));
            }
        }
        log.warn("\u51fa\u53c2: <{}>", (Object)JSON.toJSONString((Object)result));
        log.warn(name + "\u65b9\u6cd5\u7684\u6267\u884c\u65f6\u95f4\u4e3a: {}", (Object)(System.currentTimeMillis() - startTime + "\u6beb\u79d2"));
        return result;
    }

    @After(value="operatorLog()")
    public void doAfter(JoinPoint joinPoint) {
        try {
            log.info("=======\u64cd\u4f5c\u8c03\u7528" + OperatorLogAspect.getSystemLogDescription(joinPoint) + "===<\u6267\u884c\u5b8c\u6210>================");
        }
        catch (Exception e) {
            log.error("doAfter error {}", (Throwable)e);
        }
    }

    public static String getSystemLogDescription(JoinPoint joinPoint) throws Exception {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        StringBuilder description = new StringBuilder("");
        for (Method method : methods) {
            Class<?>[] clazzs;
            if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
            description.append(method.getAnnotation(OperatorLog.class).description());
            break;
        }
        return description.toString();
    }
}

