/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.aspect;

import com.google.gson.Gson;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class WebLogAspect {
    private static final Logger log = LoggerFactory.getLogger(WebLogAspect.class);

    @Pointcut(value="execution(public * com.ohaotian.task.timing.web..*.*(..))")
    public void webLog() {
    }

    @Before(value="webLog()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        log.info("========================================== Start ==========================================");
        log.info("URL            : {}", (Object)request.getRequestURL().toString());
        log.info("HTTP Method    : {}", (Object)request.getMethod());
        log.info("Class Method   : {}.{}", (Object)joinPoint.getSignature().getDeclaringTypeName(), (Object)joinPoint.getSignature().getName());
        log.info("IP             : {}", (Object)request.getRemoteAddr());
        log.info("Request Args   : {}", (Object)new Gson().toJson((Object)joinPoint.getArgs()));
    }

    @After(value="webLog()")
    public void doAfter() throws Throwable {
        log.info("=========================================== End ===========================================");
        log.info("");
    }

    @Around(value="webLog()")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = proceedingJoinPoint.proceed();
        log.info("Response Args  : {}", (Object)new Gson().toJson(result));
        log.info("Time-Consuming : {} ms", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }
}

