/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.common;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspInfoBO;
import com.ohaotian.task.timing.enums.TMSConfigResponseCodeEnum;
import com.ohaotian.task.timing.exception.BaseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    RspInfoBO handleControllerException(HttpServletRequest request, Throwable ex) {
        RspInfoBO rspInfoBO = new RspInfoBO();
        String errorCode = null;
        String message = null;
        if (ex instanceof BaseException) {
            BaseException bex = (BaseException)ex;
            errorCode = bex.getErrorCode();
            message = bex.getMessage();
            log.error("{} request error\uff0cerrorCode, , {},errorCode {} ,errorMessage {}", new Object[]{request.getRequestURI(), JSON.toJSONString((Object)rspInfoBO), errorCode, message});
        } else if (ex instanceof BindException) {
            errorCode = TMSConfigResponseCodeEnum.PARAM_ERROR.getErrorCode();
            BindingResult result = ((BindException)ex).getBindingResult();
            StringBuilder stringBuilder = new StringBuilder();
            ((List)Optional.ofNullable(result.getFieldErrors()).orElse(new ArrayList())).stream().forEach(f -> stringBuilder.append(f.getField()).append(" ").append(f.getDefaultMessage()).append(", \u5f53\u524d\u503c: '").append(f.getRejectedValue()).append("'; "));
            message = stringBuilder.toString();
            log.error("{} request error , {}", (Object)request.getRequestURI(), (Object)message);
        } else if (ex instanceof MethodArgumentNotValidException) {
            errorCode = TMSConfigResponseCodeEnum.PARAM_ERROR.getErrorCode();
            BindingResult result = ((MethodArgumentNotValidException)ex).getBindingResult();
            StringBuilder stringBuilder = new StringBuilder();
            ((List)Optional.ofNullable(result.getFieldErrors()).orElse(new ArrayList())).stream().forEach(f -> stringBuilder.append(f.getField()).append(" ").append(f.getDefaultMessage()).append(", \u5f53\u524d\u503c: '").append(f.getRejectedValue()).append("'; "));
            message = stringBuilder.toString();
            log.error("{} request error , {}", (Object)request.getRequestURI(), (Object)message);
        } else if (ex instanceof ConstraintViolationException) {
            errorCode = TMSConfigResponseCodeEnum.PARAM_ERROR.getErrorCode();
            ConstraintViolationException cex = (ConstraintViolationException)ex;
            StringBuilder stringBuilder = new StringBuilder();
            ((Set)Optional.ofNullable(cex.getConstraintViolations()).orElse(new HashSet())).stream().forEach(v -> {
                String invald = v.getInvalidValue() != null ? v.getInvalidValue().toString() : "null";
                stringBuilder.append(v.getPropertyPath()).append(" ").append(v.getMessage()).append(", \u5f53\u524d\u503c: '").append(invald.length() < 50 ? invald : invald.substring(0, 47) + "...").append("'; ");
            });
            message = stringBuilder.toString();
            log.error("{} request error , {}", (Object)request.getRequestURI(), (Object)message);
        } else {
            errorCode = TMSConfigResponseCodeEnum.SYSTEM_ERROR.getErrorCode();
            message = TMSConfigResponseCodeEnum.SYSTEM_ERROR.getErrorMessage();
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)ex);
            if (StringUtils.isNotBlank((CharSequence)stackTrace)) {
                message = stackTrace.replace("\r\n\tat", "\r\n");
            }
            log.error(request.getRequestURI() + " request error , ", ex);
        }
        rspInfoBO.setRespCode(errorCode);
        rspInfoBO.setRespDesc(message);
        return rspInfoBO;
    }
}

