/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.config;

import com.ohaotian.plugin.db.PaginationStatementHandlerInterceptor;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@PropertySource(value={"classpath:/mybatis.properties"})
public class MybatisConfig {
    @Value(value="${mybatis.mapper.xml.path}")
    private String mapperPath;
    @Value(value="${mybatis.dialect}")
    private String dialect;
    @Value(value="${mybatis.dialectClass}")
    private String dialectClass;

    @Bean
    public SqlSessionFactory sqlSessionFactoryBean(DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        sqlSessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(this.mapperPath));
        sqlSessionFactoryBean.setConfigurationProperties(this.properties());
        sqlSessionFactoryBean.setPlugins(new Interceptor[]{new PaginationStatementHandlerInterceptor()});
        return sqlSessionFactoryBean.getObject();
    }

    @Bean
    public PlatformTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public Properties properties() {
        Properties properties = new Properties();
        properties.setProperty("dialect", this.dialect);
        properties.setProperty("dialectClass", this.dialectClass);
        return properties;
    }
}

