/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.core.service.impl;

import com.dangdang.ddframe.job.lite.lifecycle.domain.JobSettings;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.reg.base.RegistryCenter;
import com.google.gson.Gson;
import com.ohaotian.task.timing.core.service.IJobManageService;
import com.ohaotian.task.timing.core.service.JobAPIService;
import com.ohaotian.task.timing.core.service.RegistryCenterService;
import com.ohaotian.task.timing.exception.AddJobException;
import com.ohaotian.task.timing.exception.DeleteJobException;
import com.ohaotian.task.timing.exception.UpdateJobException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobManageServiceImpl
implements IJobManageService {
    private static final Logger log = LogManager.getLogger(JobManageServiceImpl.class);
    final Gson gson = new Gson();
    @Autowired
    private JobAPIService jobAPIService;
    @Autowired
    private RegistryCenterService registryCenterService;

    @Override
    public int addTimedTask(JobSettings jobSettings) {
        String key;
        CoordinatorRegistryCenter registryCenter = this.registryCenterService.getRegistryCenter();
        boolean isExisted = registryCenter.isExisted(key = "/%_Metadata_Storage_%/" + jobSettings.getJobName());
        if (isExisted) {
            return 0;
        }
        try {
            registryCenter.persist(key, this.gson.toJson((Object)jobSettings));
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u65b0\u589e\u5931\u8d25:", (Throwable)ex);
            throw new AddJobException("\u65b0\u589e\u5931\u8d25:", ex);
        }
    }

    @Override
    public int updateTimedTask(JobSettings jobSettings) {
        String key;
        CoordinatorRegistryCenter registryCenter = this.registryCenterService.getRegistryCenter();
        boolean isExisted = registryCenter.isExisted(key = "/%_Metadata_Storage_%/" + jobSettings.getJobName());
        if (!isExisted) {
            return 0;
        }
        return this.update(jobSettings, (RegistryCenter)registryCenter, key);
    }

    private int update(JobSettings jobSettings, RegistryCenter registryCenter, String key) {
        try {
            registryCenter.persist(key, this.gson.toJson((Object)jobSettings));
            this.jobAPIService.getJobSettingsAPI().updateJobSettings(jobSettings);
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u66f4\u65b0\u5931\u8d25:", (Throwable)ex);
            throw new UpdateJobException("\u66f4\u65b0\u5931\u8d25:", ex);
        }
    }

    @Override
    public int saveOrUpdateTimedTask(JobSettings jobSettings) {
        CoordinatorRegistryCenter registryCenter = this.registryCenterService.getRegistryCenter();
        String key = "/%_Metadata_Storage_%/" + jobSettings.getJobName();
        return this.update(jobSettings, (RegistryCenter)registryCenter, key);
    }

    @Override
    public int removeTimedTask(String jobName) {
        CoordinatorRegistryCenter registryCenter = this.registryCenterService.getRegistryCenter();
        String key = "/%_Metadata_Storage_%/" + jobName;
        try {
            this.jobAPIService.getJobSettingsAPI().removeJobSettings(jobName);
            registryCenter.remove(key);
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u5220\u9664\u5931\u8d25:", (Throwable)ex);
            throw new DeleteJobException("\u5220\u9664\u5931\u8d25:", ex);
        }
    }
}

