/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.core.service.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.dangdang.ddframe.job.lite.lifecycle.internal.reg.RegistryCenterFactory;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Optional;
import com.ohaotian.task.timing.config.EventTraceDataSourceConfiguration;
import com.ohaotian.task.timing.core.config.RegistryCenterConfiguration;
import com.ohaotian.task.timing.core.config.RegistryCenterProperties;
import com.ohaotian.task.timing.core.service.RegistryCenterService;
import com.ohaotian.task.timing.utils.SessionEventTraceDataSourceConfiguration;
import com.ohaotian.task.timing.utils.SessionRegistryCenterConfiguration;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegistryCenterServiceImpl
implements RegistryCenterService {
    @Autowired
    private RegistryCenterProperties registryCenterProperties;
    @Autowired
    private DataSource dataSource;

    @Override
    public RegistryCenterProperties getRegistryCenterProperties() {
        return this._getRegistryCenterProperties();
    }

    @Override
    public CoordinatorRegistryCenter getRegistryCenter() {
        RegistryCenterProperties registryCenterProperties = this._getRegistryCenterProperties();
        return RegistryCenterFactory.createCoordinatorRegistryCenter((String)registryCenterProperties.getZkAddressList(), (String)registryCenterProperties.getNamespace(), (Optional)Optional.fromNullable((Object)registryCenterProperties.getDigest()));
    }

    private RegistryCenterProperties _getRegistryCenterProperties() {
        RegistryCenterConfiguration regCenterConfig = SessionRegistryCenterConfiguration.getRegistryCenterConfiguration();
        if (regCenterConfig == null) {
            return this.registryCenterProperties;
        }
        RegistryCenterProperties centerProperties = new RegistryCenterProperties();
        centerProperties.setNamespace(regCenterConfig.getNamespace());
        centerProperties.setZkAddressList(regCenterConfig.getZkAddressList());
        centerProperties.setDigest(regCenterConfig.getDigest());
        return centerProperties;
    }

    @Override
    public DataSource getDataSource() {
        EventTraceDataSourceConfiguration eventTraceDataSourceConfiguration = SessionEventTraceDataSourceConfiguration.getEventTraceDataSourceConfiguration();
        if (eventTraceDataSourceConfiguration == null) {
            return this.dataSource;
        }
        DruidDataSource result = new DruidDataSource();
        result.setDriverClassName(eventTraceDataSourceConfiguration.getDriver());
        result.setUrl(eventTraceDataSourceConfiguration.getUrl());
        result.setUsername(eventTraceDataSourceConfiguration.getUsername());
        result.setPassword(eventTraceDataSourceConfiguration.getPassword());
        return result;
    }
}

