/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class AddRequestArgsWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(AddRequestArgsWrapper.class);
    private byte[] requestBody = null;
    private static final String USER_GROUP_ID = "userGroupId";
    private static final String STAFF_NO = "staffNo";

    public AddRequestArgsWrapper(HttpServletRequest request) {
        super(request);
        try {
            String body = StreamUtils.copyToString((InputStream)request.getInputStream(), (Charset)Charset.forName("UTF-8"));
            Map bodyMap = StringUtils.isBlank((String)body) ? new TreeMap() : (Map)JSON.parseObject((String)body, Map.class);
            if (!bodyMap.containsKey(USER_GROUP_ID) || StringUtils.isBlank((String)String.valueOf(bodyMap.get(USER_GROUP_ID)))) {
                bodyMap.put(USER_GROUP_ID, 1);
            }
            if (!bodyMap.containsKey(STAFF_NO) || StringUtils.isBlank((String)String.valueOf(bodyMap.get(STAFF_NO)))) {
                bodyMap.put(STAFF_NO, 1);
            }
            body = JSONObject.toJSONString(bodyMap);
            this.requestBody = body.getBytes("UTF-8");
        }
        catch (Exception e) {
            log.error("AddRequestArgsWrapper :", (Throwable)e);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.requestBody == null) {
            this.requestBody = new byte[0];
        }
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.requestBody);
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

