/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.bo.RspInfoBO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.task.timing.bo.BusinessDefineReqBO;
import com.ohaotian.task.timing.bo.BusinessDefineReqPageBO;
import com.ohaotian.task.timing.bo.BusinessDefineRspBO;
import com.ohaotian.task.timing.bo.BusinessDefineRspPageBO;
import com.ohaotian.task.timing.bo.ShardingTriggerBO;
import com.ohaotian.task.timing.core.config.RegistryCenterProperties;
import com.ohaotian.task.timing.dao.BusinessDefineDAO;
import com.ohaotian.task.timing.dao.JobExecutionLogDAO;
import com.ohaotian.task.timing.dao.ServiceDefineDAO;
import com.ohaotian.task.timing.dao.ShardingItemExecLogDAO;
import com.ohaotian.task.timing.dao.po.BusinessDefinePO;
import com.ohaotian.task.timing.dao.po.JobExecutionLogPO;
import com.ohaotian.task.timing.dao.po.ServiceDefinePO;
import com.ohaotian.task.timing.dao.po.ShardingItemExecLogPO;
import com.ohaotian.task.timing.enums.ShardingTriggerStatusEnum;
import com.ohaotian.task.timing.service.BusinessDefineService;
import com.ohaotian.task.timing.service.IZKJobService;
import com.ohaotian.task.timing.utils.DatetUtils;
import com.ohaotian.task.timing.utils.ZookeeperClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessDefineServiceImpl
implements BusinessDefineService {
    private static final Logger logger = LoggerFactory.getLogger(BusinessDefineServiceImpl.class);
    @Autowired
    private BusinessDefineDAO businessDefineDAO;
    @Autowired
    private ServiceDefineDAO serviceDefineDAO;
    @Autowired
    private IZKJobService iZKJobService;
    @Autowired
    private JobExecutionLogDAO jobExecutionLogDAO;
    @Autowired
    private ZookeeperClient zkClient;
    @Autowired
    private RegistryCenterProperties registryCenterProperties;
    @Autowired
    private ShardingItemExecLogDAO shardingItemExecLogDAO;

    @Override
    public BusinessDefineRspBO addTimeTask(BusinessDefineReqBO reqBO) {
        logger.debug("\u5b9a\u65f6\u4efb\u52a1\u65b0\u589e\u670d\u52a1\u5165\u53c2" + (Object)((Object)reqBO));
        BusinessDefineRspBO rsp = new BusinessDefineRspBO();
        try {
            long userGroupId;
            if (reqBO.getSplitTotal() != null && reqBO.getSplitTotal().equals(0)) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u5206\u7247\u603b\u6570\u4e0d\u80fd\u5c0f\u4e8e1\uff01");
                return rsp;
            }
            String businessName = reqBO.getBusinessName();
            int i1 = this.businessDefineDAO.selectByBusinessName(businessName, userGroupId = reqBO.getUserGroupId().longValue());
            if (i1 > 0) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u4efb\u52a1\u540d\u79f0:" + reqBO.getBusinessName() + "\u4e0d\u80fd\u91cd\u590d");
                return rsp;
            }
            ServiceDefinePO serviceDefinePO = this.serviceDefineDAO.selectByPrimaryKey(reqBO.getServiceId());
            BusinessDefinePO record = new BusinessDefinePO();
            record.setServiceId(reqBO.getServiceId());
            record.setServiceName(serviceDefinePO.getServiceName());
            record.setServiceType(String.valueOf(serviceDefinePO.getServiceType()));
            record.setBusinessName(reqBO.getBusinessName());
            record.setBusinessDesc(reqBO.getBusinessDesc());
            record.setBusinessType("1");
            record.setCreateDate(new Date());
            record.setLastData(new Date());
            record.setSplitRule(reqBO.getSplitRule());
            record.setSplitTotal(reqBO.getSplitTotal());
            record.setCronExpression(reqBO.getCronExpression());
            record.setBusinessPara(reqBO.getBusinessPara() == null ? "{}" : reqBO.getBusinessPara());
            record.setDataRule(reqBO.getDataRule());
            record.setSplitNum(reqBO.getSplitNum());
            record.setBusinessStatus(1);
            record.setUserGroupId(reqBO.getUserGroupId());
            record.setStaffNo(reqBO.getStaffNo());
            record.setAlarmType(reqBO.getAlarmType());
            record.setPhoneNumber(reqBO.getPhoneNumber());
            record.setContacts(reqBO.getContacts());
            record.setIsRetry(reqBO.getIsRetry());
            record.setTimeout(reqBO.getTimeout());
            record.setRetryCount(reqBO.getRetryCount());
            this.businessDefineDAO.insert(record);
            reqBO.setBusinessId(record.getBusinessId());
            this.iZKJobService.addTimedTask(reqBO.getBusinessId());
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u65b0\u589e\u6210\u529f");
            return rsp;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u589e\u52a0\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38");
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u65b0\u589e\u5931\u8d25");
            return rsp;
        }
    }

    @Override
    public BusinessDefineRspBO updateTimeTask(BusinessDefineReqBO reqBO) {
        logger.debug("\u5b9a\u65f6\u4efb\u52a1\u4fee\u6539\u670d\u52a1\u5165\u53c2BusinessDefineReqBO:" + (Object)((Object)reqBO));
        BusinessDefineRspBO rsp = new BusinessDefineRspBO();
        try {
            if (reqBO.getSplitTotal() != null && reqBO.getSplitTotal().equals(0)) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u5206\u7247\u603b\u6570\u4e0d\u80fd\u5c0f\u4e8e1\uff01");
                return rsp;
            }
            int count = this.businessDefineDAO.selectCountByBUsinessIdAndUserGroupId(reqBO.getBusinessId(), reqBO.getUserGroupId());
            if (count == 0) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u8be5\u7528\u6237\u7ec4\u4e0b\u65e0\u6b64\u4efb\u52a1id\uff01");
                return rsp;
            }
            int count1 = this.businessDefineDAO.selectCountInUseByBusinessIdAndUserGroupId(reqBO.getBusinessId(), reqBO.getUserGroupId());
            if (count1 > 0) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u8be5\u4efb\u52a1\u5b9a\u4e49id\u6b63\u5728\u88ab\u4f7f\u7528\uff0c\u4e0d\u53ef\u4fee\u6539\uff01");
                return rsp;
            }
            int count2 = this.businessDefineDAO.selectCountByBusinessName(reqBO.getUserGroupId(), reqBO.getBusinessName(), reqBO.getBusinessId());
            if (count2 > 0) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u4efb\u52a1\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff01");
                return rsp;
            }
            ServiceDefinePO serviceDefinePO = this.serviceDefineDAO.selectByPrimaryKey(reqBO.getServiceId());
            BusinessDefinePO record = new BusinessDefinePO();
            record.setBusinessId(reqBO.getBusinessId());
            record.setServiceId(reqBO.getServiceId());
            record.setServiceName(serviceDefinePO.getServiceName());
            record.setServiceType(String.valueOf(serviceDefinePO.getServiceType()));
            record.setBusinessDesc(reqBO.getBusinessDesc());
            record.setBusinessType(reqBO.getBusinessType());
            record.setLastData(new Date());
            record.setSplitRule(reqBO.getSplitRule());
            record.setSplitTotal(reqBO.getSplitTotal());
            record.setCronExpression(reqBO.getCronExpression());
            record.setBusinessPara(reqBO.getBusinessPara());
            record.setBusinessType(reqBO.getBusinessType());
            record.setUserGroupId(reqBO.getUserGroupId());
            record.setAlarmType(reqBO.getAlarmType());
            record.setPhoneNumber(reqBO.getPhoneNumber());
            record.setContacts(reqBO.getContacts());
            record.setIsRetry(reqBO.getIsRetry());
            record.setTimeout(reqBO.getTimeout());
            record.setRetryCount(reqBO.getRetryCount());
            this.businessDefineDAO.updateByBusinessId(record);
            this.iZKJobService.updateTimedTask(reqBO.getBusinessId());
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u4fee\u6539\u6210\u529f");
            return rsp;
        }
        catch (Exception e) {
            e.printStackTrace();
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u5f02\u5e38");
            logger.error("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38");
            return rsp;
        }
    }

    @Override
    public RspPageBO<BusinessDefineRspPageBO> queryTimeTask(BusinessDefineReqPageBO reqBO) {
        logger.debug("\u5b9a\u65f6\u4efb\u52a1\u67e5\u8be2\u670d\u52a1\u5165\u53c2" + (Object)((Object)reqBO));
        RspPageBO rspBO = new RspPageBO();
        ArrayList<BusinessDefineRspPageBO> rspList = new ArrayList<BusinessDefineRspPageBO>();
        BusinessDefinePO record = new BusinessDefinePO();
        record.setBusinessId(reqBO.getBusinessId());
        record.setBusinessName(reqBO.getBusinessName());
        record.setBusinessDesc(reqBO.getBusinessDesc());
        record.setServiceName(reqBO.getServiceName());
        record.setBusinessStatus(reqBO.getBusinessStatus());
        record.setBusinessType("1");
        record.setUserGroupId(reqBO.getUserGroupId());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BusinessDefinePO> POS = this.businessDefineDAO.selectListPage((Page<BusinessDefinePO>)page, record);
        for (BusinessDefinePO po : POS) {
            BusinessDefineRspPageBO rsp = new BusinessDefineRspPageBO();
            BeanUtils.copyProperties((Object)po, (Object)((Object)rsp));
            rsp.setBusinessStatusName(this.statusToName(rsp.getBusinessStatus()));
            rsp.setServiceType(this.serviceTypeToName(rsp.getServiceType()));
            if ("".equals(rsp.getBusinessDesc())) {
                rsp.setBusinessDesc("-");
            }
            if ("".equals(rsp.getServiceType())) {
                rsp.setServiceType("-");
            }
            rspList.add(rsp);
        }
        logger.debug("\u51fa\u53c2" + rspList);
        rspBO.setRows(rspList);
        rspBO.setTotal(page.getTotalCount());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    @Override
    public RspInfoBO deleteTimeTask(BusinessDefineReqBO reqBO) {
        logger.debug("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u5165\u53c2\uff1aBusinessDefineReqBO" + (Object)((Object)reqBO));
        RspInfoBO rsp = new RspInfoBO();
        try {
            int count = this.businessDefineDAO.selectCountByBUsinessIdAndUserGroupId(reqBO.getBusinessId(), reqBO.getUserGroupId());
            if (count == 0) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u8be5\u7528\u6237\u7ec4\u4e0b\u65e0\u6b64\u4efb\u52a1id\uff01");
                return rsp;
            }
            BusinessDefinePO record = new BusinessDefinePO();
            record.setBusinessId(reqBO.getBusinessId());
            record.setServiceId(reqBO.getServiceId());
            record.setUserGroupId(reqBO.getUserGroupId());
            this.businessDefineDAO.deleteByPrimaryKey(reqBO.getBusinessId(), record.getUserGroupId());
            String jobName = reqBO.getUserGroupId() + "_" + reqBO.getBusinessName();
            int i = this.iZKJobService.removeTimedTaskByJobName(jobName);
            JobExecutionLogPO jobExecutionLogPO = new JobExecutionLogPO();
            jobExecutionLogPO.setJobName(jobName);
            this.jobExecutionLogDAO.deleteBy(jobExecutionLogPO);
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u5220\u9664\u6210\u529f");
            logger.debug("zk\u4e2d\u5220\u9664\u7684\u5b9a\u65f6\u4efb\u52a1\u6570\u91cf{}", (Object)i);
        }
        catch (Exception e) {
            e.printStackTrace();
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u5220\u9664\u5f02\u5e38");
            logger.error("\u5220\u9664\u5b9a\u65f6\u5f02\u5e38", (Throwable)e);
        }
        return rsp;
    }

    @Override
    public BusinessDefineRspPageBO queryById(BusinessDefineReqBO reqBO) {
        BusinessDefineRspPageBO BusinessDefineRspPageBO2 = new BusinessDefineRspPageBO();
        BusinessDefinePO serviceDefinePO = this.businessDefineDAO.selectByPrimaryKey(reqBO.getBusinessId());
        if (serviceDefinePO.getUserGroupId() != null && !serviceDefinePO.getUserGroupId().equals(reqBO.getUserGroupId())) {
            serviceDefinePO = null;
        }
        if (null != serviceDefinePO) {
            BusinessDefineRspPageBO2.setBusinessId(serviceDefinePO.getBusinessId());
            BusinessDefineRspPageBO2.setBusinessName(serviceDefinePO.getBusinessName());
            BusinessDefineRspPageBO2.setBusinessDesc(serviceDefinePO.getBusinessDesc());
            BusinessDefineRspPageBO2.setSplitTotal(serviceDefinePO.getSplitTotal());
            BusinessDefineRspPageBO2.setSplitRule(serviceDefinePO.getSplitRule());
            BusinessDefineRspPageBO2.setCronExpression(serviceDefinePO.getCronExpression());
            BusinessDefineRspPageBO2.setServiceId(serviceDefinePO.getServiceId());
            BusinessDefineRspPageBO2.setBusinessPara(serviceDefinePO.getBusinessPara());
            BusinessDefineRspPageBO2.setCreateDate(DatetUtils.dateToStr(serviceDefinePO.getCreateDate(), "yyyy-MM-dd HH:mm:ss"));
            BusinessDefineRspPageBO2.setBusinessStatus(serviceDefinePO.getBusinessStatus());
            BusinessDefineRspPageBO2.setBusinessStatusName(this.statusToName(serviceDefinePO.getBusinessStatus()));
            BusinessDefineRspPageBO2.setAlarmType(serviceDefinePO.getAlarmType());
            BusinessDefineRspPageBO2.setPhoneNumber(serviceDefinePO.getPhoneNumber());
            BusinessDefineRspPageBO2.setContacts(serviceDefinePO.getContacts());
            BusinessDefineRspPageBO2.setTimeout(serviceDefinePO.getTimeout());
            BusinessDefineRspPageBO2.setIsRetry(serviceDefinePO.getIsRetry());
            BusinessDefineRspPageBO2.setRetryCount(serviceDefinePO.getRetryCount());
            BusinessDefineRspPageBO2.setServiceName(this.serviceDefineDAO.selectServiceName(serviceDefinePO.getServiceId()));
            BusinessDefineRspPageBO2.setRespCode("0000");
            BusinessDefineRspPageBO2.setRespDesc("\u67e5\u8be2\u6210\u529f");
        } else {
            BusinessDefineRspPageBO2.setRespCode("8888");
            BusinessDefineRspPageBO2.setRespDesc("\u672a\u67e5\u8be2\u5230\u660e\u7ec6\u6570\u636e");
        }
        return BusinessDefineRspPageBO2;
    }

    @Override
    public RspInfoBO updateTimeStatus(BusinessDefineReqBO reqBO) {
        logger.debug("\u5b9a\u65f6\u4efb\u52a1\u751f\u5931\u6548\u4e1a\u52a1\u5904\u7406\u5f00\u59cb\u5165\u53c2\uff1a" + (Object)((Object)reqBO));
        RspInfoBO rsp = new RspInfoBO();
        try {
            int count;
            BusinessDefinePO record = new BusinessDefinePO();
            if (null == reqBO || null == reqBO.getBusinessStatus()) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u5165\u53c2\u4e2d\u7684\u5b9a\u65f6\u4efb\u52a1\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ((count = this.businessDefineDAO.selectCountByBUsinessIdAndUserGroupId(reqBO.getBusinessId(), reqBO.getUserGroupId())) == 0) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u8be5\u7528\u6237\u7ec4\u4e0b\u65e0\u6b64\u4efb\u52a1id\uff01");
                return rsp;
            }
            if (0 == reqBO.getBusinessStatus()) {
                record.setBusinessId(reqBO.getBusinessId());
                record.setLastData(new Date());
                record.setBusinessStatus(reqBO.getBusinessStatus());
                record.setUserGroupId(reqBO.getUserGroupId());
                this.businessDefineDAO.updateByPrimaryKeySelective(record);
                this.iZKJobService.removeTimedTask(reqBO.getBusinessId());
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u6210\u529f");
            }
            if (1 == reqBO.getBusinessStatus()) {
                record.setBusinessId(reqBO.getBusinessId());
                record.setLastData(new Date());
                record.setBusinessStatus(reqBO.getBusinessStatus());
                record.setUserGroupId(reqBO.getUserGroupId());
                this.businessDefineDAO.updateByPrimaryKeySelective(record);
                this.iZKJobService.addTimedTask(reqBO.getBusinessId());
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u6210\u529f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5f02\u5e38", (Throwable)e);
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u5931\u8d25");
        }
        return rsp;
    }

    @Override
    public RspInfoBO triggerShardingItem(BusinessDefineReqBO reqBO) {
        RspInfoBO rsp = new RspInfoBO();
        try {
            JobExecutionLogPO po = new JobExecutionLogPO();
            po.setId(reqBO.getId());
            JobExecutionLogPO jobExecutionLogPO = this.jobExecutionLogDAO.getModelBy(po);
            if (jobExecutionLogPO == null) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u65e0\u5bf9\u5e94\u6267\u884c\u65e5\u5fd7\uff01");
                return rsp;
            }
            Long userGroupId = Long.valueOf(jobExecutionLogPO.getJobName().substring(0, jobExecutionLogPO.getJobName().indexOf("_")));
            if (!reqBO.getUserGroupId().equals(userGroupId)) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u4e0d\u662f\u8be5\u7528\u6237\u7ec4\u4e0b\u7684\u4f5c\u4e1a\uff0c\u4e0d\u53ef\u89e6\u53d1\uff01");
                return rsp;
            }
            ShardingItemExecLogPO shardingItemExecLogPO = new ShardingItemExecLogPO();
            shardingItemExecLogPO.setJobExecLogId(jobExecutionLogPO.getId());
            shardingItemExecLogPO.setJobName(jobExecutionLogPO.getJobName());
            shardingItemExecLogPO.setShardingItem(jobExecutionLogPO.getShardingItem());
            shardingItemExecLogPO.setStartTime(new Date());
            shardingItemExecLogPO.setStatus(ShardingTriggerStatusEnum.IN_EXEC.getCode());
            shardingItemExecLogPO.setTriggerIp(jobExecutionLogPO.getIp());
            this.shardingItemExecLogDAO.insert(shardingItemExecLogPO);
            JobExecutionLogPO jobExecutionLogPO1 = new JobExecutionLogPO();
            jobExecutionLogPO1.setId(jobExecutionLogPO.getId());
            jobExecutionLogPO1.setCompleteTime(null);
            this.jobExecutionLogDAO.updateByPrimaryKey(jobExecutionLogPO1);
            ShardingTriggerBO shardingTriggerBO = new ShardingTriggerBO();
            shardingTriggerBO.setIp(jobExecutionLogPO.getIp());
            shardingTriggerBO.setJobName(jobExecutionLogPO.getJobName());
            shardingTriggerBO.setShardingItem(jobExecutionLogPO.getShardingItem());
            shardingTriggerBO.setJobExecLogId(jobExecutionLogPO.getId());
            shardingTriggerBO.setId(shardingItemExecLogPO.getId());
            String path = this.registryCenterProperties.getShardingTriggerNode() + "/" + shardingTriggerBO.getJobName() + "@-@" + shardingTriggerBO.getShardingItem();
            this.zkClient.createNode(path, JSONObject.toJSONString((Object)shardingTriggerBO));
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u89e6\u53d1\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u89e6\u53d1\u5931\u8d25");
        }
        return rsp;
    }

    private String statusToName(Integer status) {
        String statusName = null;
        if (null == status) {
            logger.debug("\u9700\u8981\u8f6c\u4e49\u72b6\u6001\u4e3a\u7a7a");
            return null;
        }
        switch (status) {
            case 0: {
                statusName = "\u5931\u6548";
                break;
            }
            case 1: {
                statusName = "\u6709\u6548";
            }
        }
        return statusName;
    }

    private String serviceTypeToName(String type) {
        String typeName = null;
        if (null == type) {
            logger.debug("\u9700\u8981\u8f6c\u4e49\u72b6\u6001\u4e3a\u7a7a");
            return null;
        }
        switch (type) {
            case "1": {
                typeName = "HTTP\u670d\u52a1";
                break;
            }
            case "2": {
                typeName = "DUBBO\u670d\u52a1";
                break;
            }
            case "3": {
                typeName = "HSF\u670d\u52a1";
                break;
            }
            case "4": {
                typeName = "PYTHON";
                break;
            }
            case "5": {
                typeName = "SHELL\u811a\u672c";
                break;
            }
            case "6": {
                typeName = "MQ\u6d88\u606f";
            }
        }
        return typeName;
    }
}

