/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.ohaotian.plugin.base.bo.RspInfoBO;
import com.ohaotian.task.timing.bo.DeleteServiceDefineReqBO;
import com.ohaotian.task.timing.dao.BusinessDefineDAO;
import com.ohaotian.task.timing.dao.HsfServiceConfigDAO;
import com.ohaotian.task.timing.dao.HttpServiceConfigDAO;
import com.ohaotian.task.timing.dao.MqServiceConfigDAO;
import com.ohaotian.task.timing.dao.PythonServiceConfigDAO;
import com.ohaotian.task.timing.dao.RtTaskDefineDAO;
import com.ohaotian.task.timing.dao.ServiceDefineDAO;
import com.ohaotian.task.timing.dao.ShellServiceConfigDAO;
import com.ohaotian.task.timing.dao.po.BusinessDefinePO;
import com.ohaotian.task.timing.dao.po.RtTaskDefinePO;
import com.ohaotian.task.timing.dao.po.ServiceDefinePO;
import com.ohaotian.task.timing.enums.ServiceStatusEnum;
import com.ohaotian.task.timing.enums.ServiceTypeEnum;
import com.ohaotian.task.timing.enums.TMSConfigResponseCodeEnum;
import com.ohaotian.task.timing.exception.TMSConfigException;
import com.ohaotian.task.timing.service.DeleteServiceDefineService;
import com.ohaotian.task.timing.utils.ZookeeperClient;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeleteServiceDefineServiceImpl
implements DeleteServiceDefineService {
    private static final Logger log = LoggerFactory.getLogger(DeleteServiceDefineServiceImpl.class);
    @Autowired
    private ServiceDefineDAO serviceDefineDAO;
    @Autowired
    private HttpServiceConfigDAO httpServiceConfigDAO;
    @Autowired
    private HsfServiceConfigDAO hsfServiceConfigDAO;
    @Autowired
    private ShellServiceConfigDAO shellServiceConfigDAO;
    @Autowired
    private MqServiceConfigDAO mqServiceConfigDAO;
    @Autowired
    private PythonServiceConfigDAO pythonServiceConfigDAO;
    @Autowired
    private RtTaskDefineDAO rtTaskDefineDAO;
    @Autowired
    private BusinessDefineDAO businessDefineDAO;
    @Autowired
    private ZookeeperClient zkClient;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RspInfoBO deleteServiceDefine(DeleteServiceDefineReqBO deleteServiceDefineReqBO) {
        Long serviceId = deleteServiceDefineReqBO.getServiceId();
        Long userGroupId = deleteServiceDefineReqBO.getUserGroupId();
        String staffNo = deleteServiceDefineReqBO.getStaffNo();
        ServiceDefinePO serviceDefinePO = this.serviceDefineDAO.queryById(deleteServiceDefineReqBO);
        if (serviceDefinePO == null) {
            log.warn("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u670d\u52a1\u4fe1\u606f\uff0cserviceId: {}, userGroupId: {}, staffNo: {}", new Object[]{serviceId, userGroupId, staffNo});
            throw new TMSConfigException(TMSConfigResponseCodeEnum.SERVICE_NOT_EXITED);
        }
        if (Objects.equals(ServiceStatusEnum.VALID.getCode(), serviceDefinePO.getStatus())) {
            log.warn("\u8be5\u670d\u52a1\u4e3a\u751f\u6548\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff01serviceId: {}", (Object)serviceId);
            throw new TMSConfigException(TMSConfigResponseCodeEnum.INVALID_CANT_DELETE);
        }
        RtTaskDefinePO tmp = this.rtTaskDefineDAO.queryServiceIdBeUsedRecord(serviceId);
        if (tmp != null) {
            log.warn("\u8be5\u670d\u52a1\u88ab\u5b9e\u65f6\u4efb\u52a1\u5b9a\u4e49\u4f7f\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff01serviceId: {}", (Object)serviceId);
            throw new TMSConfigException(TMSConfigResponseCodeEnum.SERVICE_BE_REFERENCED);
        }
        BusinessDefinePO businessDefinePO = this.businessDefineDAO.queryServiceIdBeUsedRecord(serviceId);
        if (businessDefinePO != null) {
            log.warn("\u8be5\u670d\u52a1\u88ab\u5b9a\u65f6\u4efb\u52a1\u5b9a\u4e49\u4f7f\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff01serviceId: {}", (Object)serviceId);
            throw new TMSConfigException(TMSConfigResponseCodeEnum.SERVICE_BE_REFERENCED);
        }
        ServiceTypeEnum serviceTypeEnum = ServiceTypeEnum.codeOf(serviceDefinePO.getServiceType());
        switch (serviceTypeEnum) {
            case HTTP_OR_HTTPS: {
                this.httpServiceConfigDAO.deleteByServiceId(serviceId, userGroupId, staffNo);
                break;
            }
            case HSF: {
                this.hsfServiceConfigDAO.deleteByServiceId(serviceId, userGroupId, staffNo);
                break;
            }
            case PYTHON: {
                this.pythonServiceConfigDAO.deleteByServiceId(serviceId, userGroupId, staffNo);
                break;
            }
            case SHELL: {
                this.shellServiceConfigDAO.deleteByServiceId(serviceId, userGroupId, staffNo);
                break;
            }
            case MQ: {
                this.mqServiceConfigDAO.deleteByServiceId(serviceId, userGroupId, staffNo);
                break;
            }
            default: {
                throw new IllegalArgumentException("the serviceTypeEnum not exist");
            }
        }
        this.serviceDefineDAO.delete(deleteServiceDefineReqBO);
        this.zkClient.deleteNode(String.valueOf(serviceId), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
        RspInfoBO rspInfoBO = new RspInfoBO();
        rspInfoBO.setRespCode(TMSConfigResponseCodeEnum.SUCCESS.getErrorCode());
        return rspInfoBO;
    }
}

