/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.dangdang.ddframe.job.lite.lifecycle.domain.JobSettings;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.google.gson.Gson;
import com.ohaotian.task.timing.core.service.JobAPIService;
import com.ohaotian.task.timing.core.service.RegistryCenterService;
import com.ohaotian.task.timing.exception.AddJobException;
import com.ohaotian.task.timing.exception.DeleteJobException;
import com.ohaotian.task.timing.exception.UpdateJobException;
import com.ohaotian.task.timing.service.JobSettingsService;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobSettingsServiceImpl
implements JobSettingsService {
    private static final Logger log = LogManager.getLogger(JobSettingsServiceImpl.class);
    @Autowired
    private JobAPIService jobAPIService;
    @Autowired
    private RegistryCenterService registryCenterService;

    @Override
    public void addJob(JobSettings jobSettings) throws AddJobException {
        String key;
        CoordinatorRegistryCenter registryCenter = this.registryCenterService.getRegistryCenter();
        boolean isExisted = registryCenter.isExisted(key = "/%_Metadata_Storage_%/" + jobSettings.getJobName());
        if (isExisted) {
            throw new AddJobException("\u65b0\u589e\u5931\u8d25:\u76f8\u540c\u540d\u79f0\u7684Job\u5df2\u7ecf\u5b58\u5728!");
        }
        Gson gson = new Gson();
        try {
            registryCenter.persist(key, gson.toJson((Object)jobSettings));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u65b0\u589e\u5931\u8d25:", (Throwable)ex);
            throw new AddJobException("\u65b0\u589e\u5931\u8d25:", ex);
        }
    }

    @Override
    public void removeJob(String jobName) {
        CoordinatorRegistryCenter registryCenter = this.registryCenterService.getRegistryCenter();
        String key = "/%_Metadata_Storage_%/" + jobName;
        try {
            this.jobAPIService.getJobSettingsAPI().removeJobSettings(jobName);
            registryCenter.remove(key);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u5220\u9664\u5931\u8d25:", (Throwable)ex);
            throw new DeleteJobException("\u5220\u9664\u5931\u8d25:", ex);
        }
    }

    @Override
    public void updateJob(JobSettings jobSettings) {
        String key;
        CoordinatorRegistryCenter registryCenter = this.registryCenterService.getRegistryCenter();
        boolean isExisted = registryCenter.isExisted(key = "/%_Metadata_Storage_%/" + jobSettings.getJobName());
        if (!isExisted) {
            throw new UpdateJobException("\u66f4\u65b0\u5931\u8d25:\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\"" + jobSettings.getJobName() + "\"\u7684Job!");
        }
        Gson gson = new Gson();
        try {
            registryCenter.persist(key, gson.toJson((Object)jobSettings));
            this.jobAPIService.getJobSettingsAPI().updateJobSettings(jobSettings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u66f4\u65b0\u5931\u8d25:", (Throwable)ex);
            throw new UpdateJobException("\u66f4\u65b0\u5931\u8d25:", ex);
        }
    }

    @Override
    public boolean isExisted(String jobName) {
        CoordinatorRegistryCenter registryCenter = this.registryCenterService.getRegistryCenter();
        String key = "/%_Metadata_Storage_%/" + jobName;
        return registryCenter.isExisted(key);
    }

    @Override
    public Optional<JobSettings> getJob(String jobName) {
        if (!this.isExisted(jobName)) {
            return Optional.empty();
        }
        JobSettings jobSettings = this.jobAPIService.getJobSettingsAPI().getJobSettings(jobName);
        return Optional.of(jobSettings);
    }
}

