/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.task.timing.bo.JobExecutionLogRspBO;
import com.ohaotian.task.timing.bo.QueryJobExecutionLogReqBO;
import com.ohaotian.task.timing.dao.JobExecutionLogDAO;
import com.ohaotian.task.timing.dao.po.JobExecutionLogPO;
import com.ohaotian.task.timing.service.QueryJobExecutionLogService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryJobExecutionLogServiceImpl
implements QueryJobExecutionLogService {
    private static final Logger logger = LoggerFactory.getLogger(QueryJobExecutionLogServiceImpl.class);
    @Autowired
    private JobExecutionLogDAO jobExecutionLogDAO;

    @Override
    public RspPageBO<JobExecutionLogRspBO> queryListPage(QueryJobExecutionLogReqBO queryJobExecutionLogReqBO) {
        logger.debug("\u67e5\u8be2\u670d\u52a1\u5165\u53c2" + (Object)((Object)queryJobExecutionLogReqBO));
        RspPageBO rspPageBO = new RspPageBO();
        return rspPageBO;
    }

    @Override
    public RspPageBO<JobExecutionLogRspBO> queryListPageByNameOrId(QueryJobExecutionLogReqBO queryJobExecutionLogReqBO) {
        logger.debug("\u67e5\u8be2\u670d\u52a1\u5165\u53c2" + (Object)((Object)queryJobExecutionLogReqBO));
        RspPageBO rspPageBO = new RspPageBO();
        try {
            JobExecutionLogPO jobExecutionLogPO = new JobExecutionLogPO();
            jobExecutionLogPO.setTaskId(queryJobExecutionLogReqBO.getTaskId());
            if (queryJobExecutionLogReqBO.getUserGroupId() != null && queryJobExecutionLogReqBO.getJobName() != null) {
                jobExecutionLogPO.setJobName(queryJobExecutionLogReqBO.getUserGroupId() + "_" + queryJobExecutionLogReqBO.getJobName());
            }
            jobExecutionLogPO.setIsSuccess(queryJobExecutionLogReqBO.getIsSuccess());
            jobExecutionLogPO.setOrderBy("t.start_time desc");
            jobExecutionLogPO.setUserGroupId(queryJobExecutionLogReqBO.getUserGroupId());
            if ("".equals(queryJobExecutionLogReqBO.getStartTime())) {
                jobExecutionLogPO.setStartTime(queryJobExecutionLogReqBO.getStartTime());
            } else {
                jobExecutionLogPO.setStartTime(queryJobExecutionLogReqBO.getStartTime());
            }
            if ("".equals(queryJobExecutionLogReqBO.getCompleteTime())) {
                jobExecutionLogPO.setCompleteTime(new Date().toString());
            } else {
                jobExecutionLogPO.setCompleteTime(queryJobExecutionLogReqBO.getCompleteTime());
            }
            logger.debug("\u67e5\u8be2\u6570\u636e\u5e93" + jobExecutionLogPO);
            Page page = new Page(queryJobExecutionLogReqBO.getPageNo(), queryJobExecutionLogReqBO.getPageSize());
            List<JobExecutionLogRspBO> jobLogRspBOs = this.jobExecutionLogDAO.getListPage((Page<JobExecutionLogRspBO>)page, jobExecutionLogPO);
            ArrayList<JobExecutionLogRspBO> rspBOList = new ArrayList<JobExecutionLogRspBO>();
            logger.debug("\u6570\u636e\u5e93\u8fd4\u56de" + jobLogRspBOs);
            for (JobExecutionLogRspBO jelrsp : jobLogRspBOs) {
                jelrsp.setJobName(jelrsp.getJobName().substring(jelrsp.getJobName().indexOf("_") + 1));
                if (jelrsp.getIsSuccess() == 1) {
                    jelrsp.setFailureCause("-");
                }
                if (null == jelrsp.getServiceType()) {
                    logger.debug("\u9700\u8981\u8f6c\u4e49\u72b6\u6001\u4e3a\u7a7a");
                    return null;
                }
                switch (jelrsp.getServiceType()) {
                    case "1": {
                        jelrsp.setServiceTypeName("HTTP\u670d\u52a1");
                        break;
                    }
                    case "2": {
                        jelrsp.setServiceTypeName("DUBBO\u670d\u52a1");
                        break;
                    }
                    case "3": {
                        jelrsp.setServiceTypeName("HSF\u670d\u52a1");
                        break;
                    }
                    case "4": {
                        jelrsp.setServiceTypeName("PYTHON");
                        break;
                    }
                    case "5": {
                        jelrsp.setServiceTypeName("SHELL\u811a\u672c");
                        break;
                    }
                    case "6": {
                        jelrsp.setServiceTypeName("MQ\u6d88\u606f");
                    }
                }
                rspBOList.add(jelrsp);
            }
            rspPageBO.setRows(rspBOList);
            rspPageBO.setTotal(page.getTotalCount());
            rspPageBO.setPageNo(page.getPageNo());
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setRespCode("0000");
            rspPageBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("QueryFileExportLogServiceImpl========>queryListPage\u67e5\u8be2\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new ResourceException("9999", "QueryFileExportLogServiceImpl========>queryListPage\u67e5\u8be2\u6570\u636e\u5931\u8d25");
        }
        return rspPageBO;
    }

    @Override
    public RspPageBO<JobExecutionLogRspBO> queryListPageByJobName(QueryJobExecutionLogReqBO queryJobExecutionLogReqBO) {
        logger.debug("\u67e5\u8be2\u670d\u52a1\u5165\u53c2" + (Object)((Object)queryJobExecutionLogReqBO));
        RspPageBO rspPageBO = new RspPageBO();
        try {
            JobExecutionLogPO jobExecutionLogPO = new JobExecutionLogPO();
            jobExecutionLogPO.setTaskId(queryJobExecutionLogReqBO.getTaskId());
            if (queryJobExecutionLogReqBO.getUserGroupId() != null && queryJobExecutionLogReqBO.getJobName() != null) {
                jobExecutionLogPO.setJobName(queryJobExecutionLogReqBO.getUserGroupId() + "_" + queryJobExecutionLogReqBO.getJobName());
            }
            jobExecutionLogPO.setIsSuccess(queryJobExecutionLogReqBO.getIsSuccess());
            jobExecutionLogPO.setOrderBy("t.start_time desc");
            if ("".equals(queryJobExecutionLogReqBO.getStartTime())) {
                jobExecutionLogPO.setStartTime(queryJobExecutionLogReqBO.getStartTime());
            } else {
                jobExecutionLogPO.setStartTime(queryJobExecutionLogReqBO.getStartTime());
            }
            if ("".equals(queryJobExecutionLogReqBO.getCompleteTime())) {
                jobExecutionLogPO.setCompleteTime(new Date().toString());
            } else {
                jobExecutionLogPO.setCompleteTime(queryJobExecutionLogReqBO.getCompleteTime());
            }
            logger.debug("\u67e5\u8be2\u6570\u636e\u5e93" + jobExecutionLogPO);
            Page page = new Page(queryJobExecutionLogReqBO.getPageNo(), queryJobExecutionLogReqBO.getPageSize());
            List<JobExecutionLogRspBO> jobLogRspBOs = this.jobExecutionLogDAO.getJobByJobNameListPage((Page<JobExecutionLogRspBO>)page, jobExecutionLogPO);
            ArrayList<JobExecutionLogRspBO> rspBOList = new ArrayList<JobExecutionLogRspBO>();
            logger.debug("\u6570\u636e\u5e93\u8fd4\u56de" + jobLogRspBOs);
            for (JobExecutionLogRspBO jelrsp : jobLogRspBOs) {
                jelrsp.setJobName(jelrsp.getJobName().substring(jelrsp.getJobName().indexOf("_") + 1));
                if (jelrsp.getIsSuccess() == 1) {
                    jelrsp.setFailureCause("-");
                }
                if (null == jelrsp.getServiceType()) {
                    logger.debug("\u9700\u8981\u8f6c\u4e49\u72b6\u6001\u4e3a\u7a7a");
                    return null;
                }
                switch (jelrsp.getServiceType()) {
                    case "1": {
                        jelrsp.setServiceTypeName("HTTP\u670d\u52a1");
                        break;
                    }
                    case "2": {
                        jelrsp.setServiceTypeName("DUBBO\u670d\u52a1");
                        break;
                    }
                    case "3": {
                        jelrsp.setServiceTypeName("HSF\u670d\u52a1");
                        break;
                    }
                    case "4": {
                        jelrsp.setServiceTypeName("PYTHON");
                        break;
                    }
                    case "5": {
                        jelrsp.setServiceTypeName("SHELL\u811a\u672c");
                        break;
                    }
                    case "6": {
                        jelrsp.setServiceTypeName("MQ\u6d88\u606f");
                    }
                }
                rspBOList.add(jelrsp);
            }
            rspPageBO.setRows(rspBOList);
            rspPageBO.setTotal(page.getTotalCount());
            rspPageBO.setPageNo(page.getPageNo());
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setRespCode("0000");
            rspPageBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("QueryFileExportLogServiceImpl========>queryListPage\u67e5\u8be2\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new ResourceException("9999", "QueryFileExportLogServiceImpl========>queryListPage\u67e5\u8be2\u6570\u636e\u5931\u8d25");
        }
        return rspPageBO;
    }
}

