/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.ohaotian.task.timing.bo.QueryAllServiceByServiceTypeReqBO;
import com.ohaotian.task.timing.bo.QueryAllServiceByServiceTypeRspBO;
import com.ohaotian.task.timing.bo.QueryServiceDefineAllListReqBO;
import com.ohaotian.task.timing.bo.QueryServiceDefineAllListRspBO;
import com.ohaotian.task.timing.bo.QueryServiceDefineItemRspBO;
import com.ohaotian.task.timing.dao.ServiceDefineDAO;
import com.ohaotian.task.timing.dao.po.ServiceDefinePO;
import com.ohaotian.task.timing.enums.TMSConfigResponseCodeEnum;
import com.ohaotian.task.timing.service.QueryServiceDefineAllListService;
import java.util.List;
import java.util.stream.Collectors;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryServiceDefineAllListServiceImpl
implements QueryServiceDefineAllListService {
    private static final Logger log = LoggerFactory.getLogger(QueryServiceDefineAllListServiceImpl.class);
    @Autowired
    private ServiceDefineDAO serviceDefineDAO;
    @Autowired
    private Mapper mapper;

    @Override
    public QueryServiceDefineAllListRspBO queryServiceDefineAllList(QueryServiceDefineAllListReqBO queryServiceDefineAllListReqBO) {
        Long userGroupId = queryServiceDefineAllListReqBO.getUserGroupId();
        List<ServiceDefinePO> serviceDefinePOS = this.serviceDefineDAO.queryServiceDefineAllList(userGroupId);
        QueryServiceDefineAllListRspBO queryServiceDefineAllListRspBO = new QueryServiceDefineAllListRspBO();
        queryServiceDefineAllListRspBO.setRespCode(TMSConfigResponseCodeEnum.SUCCESS.getErrorCode());
        if (!CollectionUtils.isEmpty(serviceDefinePOS)) {
            List<QueryServiceDefineItemRspBO> serviceDefines = serviceDefinePOS.stream().map(p -> (QueryServiceDefineItemRspBO)this.mapper.map(p, QueryServiceDefineItemRspBO.class)).collect(Collectors.toList());
            queryServiceDefineAllListRspBO.setServiceDefines(serviceDefines);
        }
        return queryServiceDefineAllListRspBO;
    }

    @Override
    public QueryAllServiceByServiceTypeRspBO queryServiceDefineAllListByServiceType(QueryAllServiceByServiceTypeReqBO queryAllServiceByServiceTypeReqBO) {
        Long userGroupId = queryAllServiceByServiceTypeReqBO.getUserGroupId();
        Integer serviceType = queryAllServiceByServiceTypeReqBO.getServiceType();
        List<ServiceDefinePO> serviceDefinePOS = this.serviceDefineDAO.queryServiceDefineAllListByServiceType(userGroupId, serviceType);
        QueryAllServiceByServiceTypeRspBO queryAllServiceByServiceTypeRspBO = new QueryAllServiceByServiceTypeRspBO();
        queryAllServiceByServiceTypeRspBO.setRespCode(TMSConfigResponseCodeEnum.SUCCESS.getErrorCode());
        if (!CollectionUtils.isEmpty(serviceDefinePOS)) {
            List<QueryServiceDefineItemRspBO> serviceDefines = serviceDefinePOS.stream().map(p -> (QueryServiceDefineItemRspBO)this.mapper.map(p, QueryServiceDefineItemRspBO.class)).collect(Collectors.toList());
            queryAllServiceByServiceTypeRspBO.setServiceDefines(serviceDefines);
        }
        return queryAllServiceByServiceTypeRspBO;
    }
}

