/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.ohaotian.task.timing.bo.QueryServiceDefineDetailReqBO;
import com.ohaotian.task.timing.bo.QueryServiceDefineDetailRspBO;
import com.ohaotian.task.timing.bo.ServiceDefineHsfBO;
import com.ohaotian.task.timing.bo.ServiceDefineHttpBO;
import com.ohaotian.task.timing.bo.ServiceDefineMqBO;
import com.ohaotian.task.timing.bo.ServiceDefinePythonBO;
import com.ohaotian.task.timing.bo.ServiceDefineShellBO;
import com.ohaotian.task.timing.dao.HsfServiceConfigDAO;
import com.ohaotian.task.timing.dao.HttpServiceConfigDAO;
import com.ohaotian.task.timing.dao.MqServiceConfigDAO;
import com.ohaotian.task.timing.dao.PythonServiceConfigDAO;
import com.ohaotian.task.timing.dao.ServiceDefineDAO;
import com.ohaotian.task.timing.dao.ShellServiceConfigDAO;
import com.ohaotian.task.timing.dao.po.HsfServiceConfigPO;
import com.ohaotian.task.timing.dao.po.HttpServiceConfigPO;
import com.ohaotian.task.timing.dao.po.MqServiceConfigPO;
import com.ohaotian.task.timing.dao.po.PythonServiceConfigPO;
import com.ohaotian.task.timing.dao.po.ServiceDefinePO;
import com.ohaotian.task.timing.dao.po.ShellServiceConfigPO;
import com.ohaotian.task.timing.enums.ServiceTypeEnum;
import com.ohaotian.task.timing.enums.TMSConfigResponseCodeEnum;
import com.ohaotian.task.timing.exception.TMSConfigException;
import com.ohaotian.task.timing.service.QueryServiceDefineDetailService;
import java.time.format.DateTimeFormatter;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryServiceDefineDetailServiceImpl
implements QueryServiceDefineDetailService {
    private static final Logger log = LoggerFactory.getLogger(QueryServiceDefineDetailServiceImpl.class);
    @Autowired
    private ServiceDefineDAO serviceDefineDAO;
    @Autowired
    private HttpServiceConfigDAO httpServiceConfigDAO;
    @Autowired
    private HsfServiceConfigDAO hsfServiceConfigDAO;
    @Autowired
    private ShellServiceConfigDAO shellServiceConfigDAO;
    @Autowired
    private MqServiceConfigDAO mqServiceConfigDAO;
    @Autowired
    private PythonServiceConfigDAO pythonServiceConfigDAO;
    @Autowired
    private Mapper mapper;

    @Override
    public QueryServiceDefineDetailRspBO queryServiceDefineDetail(QueryServiceDefineDetailReqBO queryServiceDefineDetailReqBO) {
        ServiceDefinePO serviceDefinePO = this.serviceDefineDAO.select(queryServiceDefineDetailReqBO);
        if (serviceDefinePO == null) {
            log.warn("\u672a\u67e5\u8be2\u5230\u8be5\u670d\u52a1\u5b9a\u4e49\u6570\u636e\uff0cserviceId: {}", (Object)queryServiceDefineDetailReqBO.getServiceId());
            throw new TMSConfigException(TMSConfigResponseCodeEnum.SERVICE_NOT_EXITED);
        }
        QueryServiceDefineDetailRspBO queryServiceDefineDetailRspBO = (QueryServiceDefineDetailRspBO)this.mapper.map((Object)serviceDefinePO, QueryServiceDefineDetailRspBO.class);
        queryServiceDefineDetailRspBO.setCreateTime(serviceDefinePO.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        queryServiceDefineDetailRspBO.setModifiedTime(serviceDefinePO.getModifiedTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        long serviceId = serviceDefinePO.getServiceId();
        ServiceTypeEnum serviceTypeEnum = ServiceTypeEnum.codeOf(serviceDefinePO.getServiceType());
        switch (serviceTypeEnum) {
            case HTTP_OR_HTTPS: {
                HttpServiceConfigPO httpServiceConfigPO = this.httpServiceConfigDAO.queryByServiceId(serviceId);
                if (httpServiceConfigPO == null) break;
                ServiceDefineHttpBO serviceDefineHttpRspBO = (ServiceDefineHttpBO)this.mapper.map((Object)httpServiceConfigPO, ServiceDefineHttpBO.class);
                queryServiceDefineDetailRspBO.setHttpConfig(serviceDefineHttpRspBO);
                break;
            }
            case HSF: {
                HsfServiceConfigPO hsfServiceConfigPO = this.hsfServiceConfigDAO.queryByServiceId(serviceId);
                if (hsfServiceConfigPO == null) break;
                ServiceDefineHsfBO serviceDefineHsfRspBO = (ServiceDefineHsfBO)this.mapper.map((Object)hsfServiceConfigPO, ServiceDefineHsfBO.class);
                queryServiceDefineDetailRspBO.setHsfConfig(serviceDefineHsfRspBO);
                break;
            }
            case MQ: {
                MqServiceConfigPO mqServiceConfigPO = this.mqServiceConfigDAO.queryByServiceId(serviceId);
                if (mqServiceConfigPO == null) break;
                ServiceDefineMqBO serviceDefineMqRspBO = (ServiceDefineMqBO)this.mapper.map((Object)mqServiceConfigPO, ServiceDefineMqBO.class);
                queryServiceDefineDetailRspBO.setMqConfig(serviceDefineMqRspBO);
                break;
            }
            case SHELL: {
                ShellServiceConfigPO shellServiceConfigPO = this.shellServiceConfigDAO.queryByServiceId(serviceId);
                if (shellServiceConfigPO == null) break;
                ServiceDefineShellBO serviceDefineShellRspBO = (ServiceDefineShellBO)this.mapper.map((Object)shellServiceConfigPO, ServiceDefineShellBO.class);
                queryServiceDefineDetailRspBO.setShellConfig(serviceDefineShellRspBO);
                break;
            }
            case PYTHON: {
                PythonServiceConfigPO pythonServiceConfigPO = this.pythonServiceConfigDAO.queryByServiceId(serviceId);
                if (pythonServiceConfigPO == null) break;
                ServiceDefinePythonBO serviceDefinePythonRspBO = (ServiceDefinePythonBO)this.mapper.map((Object)pythonServiceConfigPO, ServiceDefinePythonBO.class);
                queryServiceDefineDetailRspBO.setPythonConfig(serviceDefinePythonRspBO);
                break;
            }
        }
        queryServiceDefineDetailRspBO.setRespCode(TMSConfigResponseCodeEnum.SUCCESS.getErrorCode());
        return queryServiceDefineDetailRspBO;
    }
}

