/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.task.timing.bo.QueryServiceDefineListPageReqBO;
import com.ohaotian.task.timing.bo.QueryServiceDefineListPageRspBO;
import com.ohaotian.task.timing.dao.ServiceDefineDAO;
import com.ohaotian.task.timing.dao.po.ServiceDefinePO;
import com.ohaotian.task.timing.enums.ServiceTypeEnum;
import com.ohaotian.task.timing.enums.TMSConfigResponseCodeEnum;
import com.ohaotian.task.timing.service.QueryServiceDefineListPageService;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryServiceDefineListPageServiceImpl
implements QueryServiceDefineListPageService {
    private static final Logger log = LoggerFactory.getLogger(QueryServiceDefineListPageServiceImpl.class);
    @Autowired
    private ServiceDefineDAO serviceDefineDAO;
    @Autowired
    private Mapper mapper;

    @Override
    public RspPageBO queryServiceDefineListPage(QueryServiceDefineListPageReqBO queryServiceDefineListPageReqBO) {
        long userGroupId = queryServiceDefineListPageReqBO.getUserGroupId();
        String staffNo = queryServiceDefineListPageReqBO.getStaffNo();
        int pageSize = queryServiceDefineListPageReqBO.getPageSize();
        int pageNo = queryServiceDefineListPageReqBO.getPageNo();
        String serviceName = queryServiceDefineListPageReqBO.getServiceName();
        String serviceType = queryServiceDefineListPageReqBO.getServiceType();
        Page page = new Page(pageNo, pageSize);
        List queryServiceDefineListPageRspBOS = null;
        List<ServiceDefinePO> serviceDefinePOS = this.serviceDefineDAO.queryServiceDefineListPage(userGroupId, staffNo, (Page<ServiceDefinePO>)page, serviceName, serviceType);
        queryServiceDefineListPageRspBOS = serviceDefinePOS.stream().map(p -> {
            QueryServiceDefineListPageRspBO queryServiceDefineListPageRspBO = (QueryServiceDefineListPageRspBO)this.mapper.map(p, QueryServiceDefineListPageRspBO.class);
            queryServiceDefineListPageRspBO.setServiceType(ServiceTypeEnum.codeOf(p.getServiceType()).getDesc());
            queryServiceDefineListPageRspBO.setCreateTime(p.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            return queryServiceDefineListPageRspBO;
        }).collect(Collectors.toList());
        RspPageBO rspPageBO = new RspPageBO();
        rspPageBO.setRespCode(TMSConfigResponseCodeEnum.SUCCESS.getErrorCode());
        rspPageBO.setRows(queryServiceDefineListPageRspBOS);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalCount());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

