/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.bo.RspInfoBO;
import com.ohaotian.task.timing.bo.RegisteHsfServiceConfigReqBO;
import com.ohaotian.task.timing.bo.RegisteHttpServiceConfigReqBO;
import com.ohaotian.task.timing.bo.RegisteMqServiceConfigReqBO;
import com.ohaotian.task.timing.bo.RegistePythonServiceConfigReqBO;
import com.ohaotian.task.timing.bo.RegisteServiceDefineReqBO;
import com.ohaotian.task.timing.bo.RegisteShellServiceConfigReqBO;
import com.ohaotian.task.timing.bo.ZkHsfServiceConfigBO;
import com.ohaotian.task.timing.bo.ZkHttpServiceConfigBO;
import com.ohaotian.task.timing.bo.ZkMqServiceConfigBO;
import com.ohaotian.task.timing.bo.ZkPythonServiceConfigBO;
import com.ohaotian.task.timing.bo.ZkServiceDefineBO;
import com.ohaotian.task.timing.bo.ZkShellServiceConfigBO;
import com.ohaotian.task.timing.dao.HsfServiceConfigDAO;
import com.ohaotian.task.timing.dao.HttpServiceConfigDAO;
import com.ohaotian.task.timing.dao.MqServiceConfigDAO;
import com.ohaotian.task.timing.dao.PythonServiceConfigDAO;
import com.ohaotian.task.timing.dao.ServiceDefineDAO;
import com.ohaotian.task.timing.dao.ShellServiceConfigDAO;
import com.ohaotian.task.timing.dao.po.HsfServiceConfigPO;
import com.ohaotian.task.timing.dao.po.HttpServiceConfigPO;
import com.ohaotian.task.timing.dao.po.MqServiceConfigPO;
import com.ohaotian.task.timing.dao.po.PythonServiceConfigPO;
import com.ohaotian.task.timing.dao.po.ServiceDefinePO;
import com.ohaotian.task.timing.dao.po.ShellServiceConfigPO;
import com.ohaotian.task.timing.enums.ServiceStatusEnum;
import com.ohaotian.task.timing.enums.ServiceTypeEnum;
import com.ohaotian.task.timing.enums.TMSConfigResponseCodeEnum;
import com.ohaotian.task.timing.exception.TMSConfigException;
import com.ohaotian.task.timing.service.RegisteServiceDefineService;
import com.ohaotian.task.timing.utils.ZookeeperClient;
import java.util.concurrent.ExecutorService;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RegisteServiceDefineServiceImpl
implements RegisteServiceDefineService {
    private static final Logger log = LoggerFactory.getLogger(RegisteServiceDefineServiceImpl.class);
    @Autowired
    private ServiceDefineDAO serviceDefineDAO;
    @Autowired
    private HttpServiceConfigDAO httpServiceConfigDAO;
    @Autowired
    private HsfServiceConfigDAO hsfServiceConfigDAO;
    @Autowired
    private ShellServiceConfigDAO shellServiceConfigDAO;
    @Autowired
    private MqServiceConfigDAO mqServiceConfigDAO;
    @Autowired
    private PythonServiceConfigDAO pythonServiceConfigDAO;
    @Autowired
    private Mapper mapper;
    @Autowired
    private ZookeeperClient zkClient;
    @Autowired
    private ExecutorService executorService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RspInfoBO registeServiceDefine(RegisteServiceDefineReqBO registeServiceDefineReqBO) {
        Integer serviceType = registeServiceDefineReqBO.getServiceType();
        Long userGroupId = registeServiceDefineReqBO.getUserGroupId();
        String staffNo = registeServiceDefineReqBO.getStaffNo();
        String serviceName = registeServiceDefineReqBO.getServiceName();
        ServiceTypeEnum serviceTypeEnum = ServiceTypeEnum.codeOf(serviceType);
        if (serviceTypeEnum == null) {
            log.warn("\u6ce8\u518c\u670d\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728\uff0cserviceType:{}", (Object)registeServiceDefineReqBO.getServiceType());
            throw new TMSConfigException(TMSConfigResponseCodeEnum.PARAM_ERROR);
        }
        ServiceDefinePO serviceDefinePO = (ServiceDefinePO)this.mapper.map((Object)registeServiceDefineReqBO, ServiceDefinePO.class);
        ServiceDefinePO tmp = this.serviceDefineDAO.queryByServiceName(serviceName, userGroupId);
        if (tmp != null) {
            log.warn("\u6ce8\u518c\u670d\u52a1\u540d\u79f0\u91cd\u590d\uff0cserviceName:{}", (Object)serviceName);
            throw new TMSConfigException(TMSConfigResponseCodeEnum.SERVICE_NAME_REPEAT);
        }
        this.serviceDefineDAO.insert(serviceDefinePO);
        Long serviceDefineId = serviceDefinePO.getServiceId();
        switch (serviceTypeEnum) {
            case HTTP_OR_HTTPS: {
                RegisteHttpServiceConfigReqBO registeHttpServiceConfigReqBO = registeServiceDefineReqBO.getHttpConfig();
                HttpServiceConfigPO httpServiceConfigPO = (HttpServiceConfigPO)this.mapper.map((Object)registeHttpServiceConfigReqBO, HttpServiceConfigPO.class);
                httpServiceConfigPO.setServiceId(serviceDefineId);
                httpServiceConfigPO.setUserGroupId(userGroupId);
                httpServiceConfigPO.setStaffNo(staffNo);
                httpServiceConfigPO.setStatus(registeServiceDefineReqBO.getStatus());
                this.httpServiceConfigDAO.insert(httpServiceConfigPO);
                this.executorService.submit(() -> this.pushHttpServiceDefine2Zookeeper(serviceDefineId, httpServiceConfigPO));
                break;
            }
            case HSF: {
                RegisteHsfServiceConfigReqBO registeHsfServiceConfigReqBO = registeServiceDefineReqBO.getHsfConfig();
                HsfServiceConfigPO hsfServiceConfigPO = (HsfServiceConfigPO)this.mapper.map((Object)registeHsfServiceConfigReqBO, HsfServiceConfigPO.class);
                hsfServiceConfigPO.setServiceId(serviceDefineId);
                hsfServiceConfigPO.setUserGroupId(userGroupId);
                hsfServiceConfigPO.setStaffNo(staffNo);
                this.hsfServiceConfigDAO.insert(hsfServiceConfigPO);
                this.executorService.submit(() -> this.pushHsfServiceDefine2Zookeeper(serviceDefineId, hsfServiceConfigPO));
                break;
            }
            case SHELL: {
                RegisteShellServiceConfigReqBO registeShellServiceConfigReqBO = registeServiceDefineReqBO.getShellConfig();
                ShellServiceConfigPO shellServiceConfigPO = (ShellServiceConfigPO)this.mapper.map((Object)registeShellServiceConfigReqBO, ShellServiceConfigPO.class);
                shellServiceConfigPO.setServiceId(serviceDefineId);
                shellServiceConfigPO.setUserGroupId(userGroupId);
                shellServiceConfigPO.setStaffNo(staffNo);
                this.shellServiceConfigDAO.insert(shellServiceConfigPO);
                this.executorService.submit(() -> this.pushShellServiceDefine2Zookeeper(serviceDefineId, shellServiceConfigPO));
                break;
            }
            case PYTHON: {
                RegistePythonServiceConfigReqBO registePythonServiceConfigReqBO = registeServiceDefineReqBO.getPythonConfig();
                PythonServiceConfigPO pythonServiceConfigPO = (PythonServiceConfigPO)this.mapper.map((Object)registePythonServiceConfigReqBO, PythonServiceConfigPO.class);
                pythonServiceConfigPO.setServiceId(serviceDefineId);
                pythonServiceConfigPO.setUserGroupId(userGroupId);
                pythonServiceConfigPO.setStaffNo(staffNo);
                this.pythonServiceConfigDAO.insert(pythonServiceConfigPO);
                this.executorService.submit(() -> this.pushPythonServiceDefine2Zookeeper(serviceDefineId, pythonServiceConfigPO));
                break;
            }
            case MQ: {
                RegisteMqServiceConfigReqBO registeMqServiceConfigReqBO = registeServiceDefineReqBO.getMqConfig();
                MqServiceConfigPO mqServiceConfigPO = (MqServiceConfigPO)this.mapper.map((Object)registeMqServiceConfigReqBO, MqServiceConfigPO.class);
                mqServiceConfigPO.setServiceId(serviceDefineId);
                mqServiceConfigPO.setUserGroupId(userGroupId);
                mqServiceConfigPO.setStaffNo(staffNo);
                this.mqServiceConfigDAO.insert(mqServiceConfigPO);
                this.executorService.submit(() -> this.pushMQServiceDefine2Zookeeper(serviceDefineId, mqServiceConfigPO));
                break;
            }
            default: {
                throw new TMSConfigException(TMSConfigResponseCodeEnum.PARAM_ERROR);
            }
        }
        RspInfoBO rspInfoBO = new RspInfoBO();
        rspInfoBO.setRespCode(TMSConfigResponseCodeEnum.SUCCESS.getErrorCode());
        return rspInfoBO;
    }

    private void pushMQServiceDefine2Zookeeper(Long serviceDefineId, MqServiceConfigPO mqServiceConfigPO) {
        ZkServiceDefineBO zkServiceDefineBO = new ZkServiceDefineBO();
        zkServiceDefineBO.setServiceId(serviceDefineId);
        zkServiceDefineBO.setServiceType(ServiceTypeEnum.MQ.getCode());
        zkServiceDefineBO.setStatus(ServiceStatusEnum.VALID.getCode());
        ZkMqServiceConfigBO zkMqServiceConfigBO = (ZkMqServiceConfigBO)this.mapper.map((Object)mqServiceConfigPO, ZkMqServiceConfigBO.class);
        zkServiceDefineBO.setMqConfig(zkMqServiceConfigBO);
        this.zkClient.setData(serviceDefineId.toString(), JSONObject.toJSONString((Object)zkServiceDefineBO), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
    }

    private void pushPythonServiceDefine2Zookeeper(Long serviceDefineId, PythonServiceConfigPO pythonServiceConfigPO) {
        ZkServiceDefineBO zkServiceDefineBO = new ZkServiceDefineBO();
        zkServiceDefineBO.setServiceId(serviceDefineId);
        zkServiceDefineBO.setServiceType(ServiceTypeEnum.PYTHON.getCode());
        zkServiceDefineBO.setStatus(ServiceStatusEnum.VALID.getCode());
        ZkPythonServiceConfigBO zkPythonServiceConfigBO = (ZkPythonServiceConfigBO)this.mapper.map((Object)pythonServiceConfigPO, ZkPythonServiceConfigBO.class);
        zkServiceDefineBO.setPythonConfig(zkPythonServiceConfigBO);
        this.zkClient.setData(serviceDefineId.toString(), JSONObject.toJSONString((Object)zkServiceDefineBO), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
    }

    private void pushShellServiceDefine2Zookeeper(Long serviceDefineId, ShellServiceConfigPO shellServiceConfigPO) {
        ZkServiceDefineBO zkServiceDefineBO = new ZkServiceDefineBO();
        zkServiceDefineBO.setServiceId(serviceDefineId);
        zkServiceDefineBO.setServiceType(ServiceTypeEnum.SHELL.getCode());
        zkServiceDefineBO.setStatus(ServiceStatusEnum.VALID.getCode());
        ZkShellServiceConfigBO zkShellServiceConfigBO = (ZkShellServiceConfigBO)this.mapper.map((Object)shellServiceConfigPO, ZkShellServiceConfigBO.class);
        zkServiceDefineBO.setShellConfig(zkShellServiceConfigBO);
        this.zkClient.setData(serviceDefineId.toString(), JSONObject.toJSONString((Object)zkServiceDefineBO), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
    }

    private void pushHsfServiceDefine2Zookeeper(Long serviceDefineId, HsfServiceConfigPO hsfServiceConfigPO) {
        ZkServiceDefineBO zkServiceDefineBO = new ZkServiceDefineBO();
        zkServiceDefineBO.setServiceId(serviceDefineId);
        zkServiceDefineBO.setServiceType(ServiceTypeEnum.HSF.getCode());
        zkServiceDefineBO.setStatus(ServiceStatusEnum.VALID.getCode());
        ZkHsfServiceConfigBO zkHsfServiceConfigBO = (ZkHsfServiceConfigBO)this.mapper.map((Object)hsfServiceConfigPO, ZkHsfServiceConfigBO.class);
        zkServiceDefineBO.setHsfConfig(zkHsfServiceConfigBO);
        this.zkClient.setData(serviceDefineId.toString(), JSONObject.toJSONString((Object)zkServiceDefineBO), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
    }

    private void pushHttpServiceDefine2Zookeeper(Long serviceDefineId, HttpServiceConfigPO httpServiceConfigPO) {
        ZkServiceDefineBO zkServiceDefineBO = new ZkServiceDefineBO();
        zkServiceDefineBO.setServiceId(serviceDefineId);
        zkServiceDefineBO.setServiceType(ServiceTypeEnum.HTTP_OR_HTTPS.getCode());
        zkServiceDefineBO.setStatus(ServiceStatusEnum.VALID.getCode());
        ZkHttpServiceConfigBO zkHttpServiceConfigBO = (ZkHttpServiceConfigBO)this.mapper.map((Object)httpServiceConfigPO, ZkHttpServiceConfigBO.class);
        zkServiceDefineBO.setHttpConfig(zkHttpServiceConfigBO);
        this.zkClient.setData(serviceDefineId.toString(), JSONObject.toJSONString((Object)zkServiceDefineBO), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
    }
}

