/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.task.timing.bo.AlarmDataBO;
import com.ohaotian.task.timing.bo.NoticeCenterReqBO;
import com.ohaotian.task.timing.bo.NoticeCenterRspBO;
import com.ohaotian.task.timing.bo.NoticeInfoBO;
import com.ohaotian.task.timing.bo.SendAlarmBO;
import com.ohaotian.task.timing.bo.SendAlarmReqBO;
import com.ohaotian.task.timing.bo.SendAlarmRspBO;
import com.ohaotian.task.timing.dao.AlarmLogDAO;
import com.ohaotian.task.timing.dao.BusinessDefineDAO;
import com.ohaotian.task.timing.dao.JobExecutionLogDAO;
import com.ohaotian.task.timing.dao.po.AlarmLogPO;
import com.ohaotian.task.timing.dao.po.BusinessDefinePO;
import com.ohaotian.task.timing.dao.po.JobExecutionLogPO;
import com.ohaotian.task.timing.service.SendAlarmService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SendAlarmServiceImpl
implements SendAlarmService {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private AlarmLogDAO alarmLogDAO;
    @Autowired
    private BusinessDefineDAO businessDefineDAO;
    @Autowired
    private JobExecutionLogDAO jobExecutionLogDAO;
    @Value(value="${alarm.systemId}")
    private String SYSTEM_ID;
    @Value(value="${alarm.moduleId}")
    private String MODULE_ID;
    @Value(value="${alarm.busiCode}")
    private String BUSI_CODE;
    @Value(value="${alarm.proviceCode}")
    private String PROVINCE_CODE;
    @Value(value="${alarm.eparchyCode}")
    private String EPARCHY_CODE;
    @Value(value="${alarm.url}")
    private String url;

    @Override
    public SendAlarmRspBO sendAlarm(SendAlarmReqBO sendAlarmReqBO) {
        SendAlarmRspBO rspBO = new SendAlarmRspBO();
        try {
            Date now = new Date();
            List<JobExecutionLogPO> jobExecutionLogPOS = this.jobExecutionLogDAO.selectFailLogForAlarm(now, new Date(now.getTime() - 300000L));
            if (jobExecutionLogPOS != null && jobExecutionLogPOS.size() > 0) {
                for (JobExecutionLogPO jobExecutionLogPO : jobExecutionLogPOS) {
                    if (jobExecutionLogPO.getJobName().split("_")[1].equals("\u5b9a\u65f6\u4efb\u52a1\u5e73\u53f0\u77ed\u4fe1\u544a\u8b66\u4efb\u52a1")) continue;
                    this.sendAlarmInfo(jobExecutionLogPO);
                }
            }
            rspBO.setRespCode("0000");
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u53d1\u9001\u544a\u8b66\u5931\u8d25\uff1a" + e.getMessage());
            return rspBO;
        }
        return rspBO;
    }

    private void sendAlarmInfo(JobExecutionLogPO jobExecutionLogPO) throws Exception {
        try {
            Long userGroupId = Long.valueOf(jobExecutionLogPO.getJobName().split("_")[0]);
            String businessName = jobExecutionLogPO.getJobName().split("_")[1];
            BusinessDefinePO businessDefinePO = this.businessDefineDAO.selectPOByBusinessName(businessName, userGroupId);
            if (businessDefinePO != null) {
                SendAlarmBO sendAlarmBO = new SendAlarmBO();
                sendAlarmBO.setBusinessId(businessDefinePO.getBusinessId());
                sendAlarmBO.setBusinessName(businessDefinePO.getBusinessName());
                sendAlarmBO.setShardingItem(jobExecutionLogPO.getShardingItem());
                sendAlarmBO.setExceptionInfo(jobExecutionLogPO.getFailureCause().substring(0, 500));
                NoticeCenterReqBO noticeCenterReqBO = new NoticeCenterReqBO();
                NoticeInfoBO noticeInfoBO = new NoticeInfoBO();
                ArrayList<AlarmDataBO> alarmDataBOs = new ArrayList<AlarmDataBO>();
                String[] phoneNumbers = businessDefinePO.getPhoneNumber().split(",");
                for (int i = 0; i < phoneNumbers.length; ++i) {
                    AlarmDataBO alarmDataBO = new AlarmDataBO();
                    alarmDataBO.setRECV_OBJECT(phoneNumbers[i]);
                    alarmDataBOs.add(alarmDataBO);
                }
                noticeInfoBO.setBUSI_CODE(this.BUSI_CODE);
                noticeInfoBO.setEPARCHY_CODE(this.EPARCHY_CODE);
                noticeInfoBO.setMODULE_ID(this.MODULE_ID);
                noticeInfoBO.setPROVINCE_CODE(this.PROVINCE_CODE);
                noticeInfoBO.setSYSTEM_ID(this.SYSTEM_ID);
                noticeInfoBO.setNOTICE_CONTENT("\u6279\u91cf\u5e73\u53f0\u544a\u8b66\uff1a" + JSONObject.toJSONString((Object)sendAlarmBO));
                noticeInfoBO.setDATA(alarmDataBOs);
                noticeCenterReqBO.setNOTICEINFO(noticeInfoBO);
                JSONObject jsonObject = (JSONObject)this.restTemplate.postForObject(this.url, JSONObject.toJSON((Object)noticeCenterReqBO), JSONObject.class, new Object[0]);
                NoticeCenterRspBO noticeCenterRspBO = (NoticeCenterRspBO)jsonObject.toJavaObject(NoticeCenterRspBO.class);
                AlarmLogPO alarmLogPO = new AlarmLogPO();
                alarmLogPO.setAlarmContent(JSONObject.toJSONString((Object)sendAlarmBO));
                alarmLogPO.setBusinessId(businessDefinePO.getBusinessId());
                alarmLogPO.setRspDesc(noticeCenterRspBO.getRSP().getRSP_DESC());
                alarmLogPO.setData(StringUtils.join((Object[])noticeCenterRspBO.getRSP().getDATA(), (String)","));
                alarmLogPO.setCreateTime(new Date());
                if (noticeCenterRspBO != null) {
                    if (noticeCenterRspBO.getSTATUS().equals("0000")) {
                        alarmLogPO.setIsSuccess(1);
                    } else {
                        alarmLogPO.setIsSuccess(0);
                    }
                }
                this.alarmLogDAO.insert(alarmLogPO);
                JobExecutionLogPO jobExecutionLogPO1 = new JobExecutionLogPO();
                jobExecutionLogPO1.setAlarmStatus(1);
                jobExecutionLogPO1.setId(jobExecutionLogPO.getId());
                this.jobExecutionLogDAO.updateAlarmStatusById(jobExecutionLogPO1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }
}

