/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.bo.RspInfoBO;
import com.ohaotian.task.timing.bo.ServiceDefineHsfBO;
import com.ohaotian.task.timing.bo.ServiceDefineHttpBO;
import com.ohaotian.task.timing.bo.ServiceDefineMqBO;
import com.ohaotian.task.timing.bo.ServiceDefinePythonBO;
import com.ohaotian.task.timing.bo.ServiceDefineShellBO;
import com.ohaotian.task.timing.bo.UpdateServiceDefineReqBO;
import com.ohaotian.task.timing.bo.ZkHsfServiceConfigBO;
import com.ohaotian.task.timing.bo.ZkHttpServiceConfigBO;
import com.ohaotian.task.timing.bo.ZkMqServiceConfigBO;
import com.ohaotian.task.timing.bo.ZkPythonServiceConfigBO;
import com.ohaotian.task.timing.bo.ZkServiceDefineBO;
import com.ohaotian.task.timing.bo.ZkShellServiceConfigBO;
import com.ohaotian.task.timing.dao.BatchTaskDAO;
import com.ohaotian.task.timing.dao.BusinessDefineDAO;
import com.ohaotian.task.timing.dao.HsfServiceConfigDAO;
import com.ohaotian.task.timing.dao.HttpServiceConfigDAO;
import com.ohaotian.task.timing.dao.JobExecutionLogDAO;
import com.ohaotian.task.timing.dao.MqServiceConfigDAO;
import com.ohaotian.task.timing.dao.PythonServiceConfigDAO;
import com.ohaotian.task.timing.dao.RtTaskDefineDAO;
import com.ohaotian.task.timing.dao.ServiceDefineDAO;
import com.ohaotian.task.timing.dao.ShellServiceConfigDAO;
import com.ohaotian.task.timing.dao.po.BusinessDefinePO;
import com.ohaotian.task.timing.dao.po.RtTaskDefinePO;
import com.ohaotian.task.timing.dao.po.ServiceDefinePO;
import com.ohaotian.task.timing.enums.ServiceTypeEnum;
import com.ohaotian.task.timing.enums.TMSConfigResponseCodeEnum;
import com.ohaotian.task.timing.exception.TMSConfigException;
import com.ohaotian.task.timing.service.UpdateServiceDefineService;
import com.ohaotian.task.timing.utils.ZookeeperClient;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UpdateServiceDefineServiceImpl
implements UpdateServiceDefineService {
    private static final Logger log = LoggerFactory.getLogger(UpdateServiceDefineServiceImpl.class);
    @Autowired
    private ServiceDefineDAO serviceDefineDAO;
    @Autowired
    private BatchTaskDAO batchTaskDAO;
    @Autowired
    private HttpServiceConfigDAO httpServiceConfigDAO;
    @Autowired
    private HsfServiceConfigDAO hsfServiceConfigDAO;
    @Autowired
    private ShellServiceConfigDAO shellServiceConfigDAO;
    @Autowired
    private MqServiceConfigDAO mqServiceConfigDAO;
    @Autowired
    private PythonServiceConfigDAO pythonServiceConfigDAO;
    @Autowired
    private BusinessDefineDAO businessDefineDAO;
    @Autowired
    private JobExecutionLogDAO jobExecutionLogDAO;
    @Autowired
    private RtTaskDefineDAO rtTaskDefineDAO;
    @Autowired
    private Mapper mapper;
    @Autowired
    private ZookeeperClient zkClient;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RspInfoBO updateServiceDefine(UpdateServiceDefineReqBO updateServiceDefineReqBO) {
        Long serviceId = updateServiceDefineReqBO.getServiceId();
        Long userGroupId = updateServiceDefineReqBO.getUserGroupId();
        String serviceName = updateServiceDefineReqBO.getServiceName();
        RtTaskDefinePO taskDefinePO = this.rtTaskDefineDAO.queryServiceIdBeUsedValidRecord(serviceId);
        if (taskDefinePO != null) {
            log.warn("\u8be5\u670d\u52a1\u5df2\u88ab\u751f\u6548\u7684\u5b9e\u65f6\u4efb\u52a1\u5b9a\u4e49\u5f15\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff0cserviceId: {}", (Object)serviceId);
            throw new TMSConfigException(TMSConfigResponseCodeEnum.SERVICE_BE_VALID_REAL_TASK_DEFINE_REFERENCED);
        }
        BusinessDefinePO businessDefinePO = this.businessDefineDAO.queryServiceIdBeUsedValidRecord(serviceId);
        if (businessDefinePO != null) {
            log.warn("\u8be5\u670d\u52a1\u5df2\u88ab\u751f\u6548\u7684\u5b9a\u65f6\u4efb\u52a1\u5b9a\u4e49\u5f15\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u6216\u5931\u6548\u64cd\u4f5c\uff0cserviceId: {}", (Object)serviceId);
            throw new TMSConfigException(TMSConfigResponseCodeEnum.SERVICE_BE_VALID_TIMING_TASK_DEFINE_REFERENCED);
        }
        ServiceDefinePO tmp = this.serviceDefineDAO.queryIsAnotherSameServiceNameExited(serviceId, serviceName, userGroupId);
        if (tmp != null) {
            log.warn("\u8be5\u670d\u52a1\u540d\u79f0\u91cd\u590d\uff0cserviceId: {}\uff0c serviceName: {}", (Object)serviceId, (Object)serviceName);
            throw new TMSConfigException(TMSConfigResponseCodeEnum.SERVICE_NAME_REPEAT);
        }
        ServiceDefinePO serviceDefinePO = (ServiceDefinePO)this.mapper.map((Object)updateServiceDefineReqBO, ServiceDefinePO.class);
        this.serviceDefineDAO.updateByPrimaryKeySelective(serviceDefinePO);
        ServiceTypeEnum serviceTypeEnum = ServiceTypeEnum.codeOf(updateServiceDefineReqBO.getServiceType());
        switch (serviceTypeEnum) {
            case HTTP_OR_HTTPS: {
                ServiceDefineHttpBO serviceDefineHttpBO = new ServiceDefineHttpBO();
                serviceDefineHttpBO.setServiceId(serviceId);
                serviceDefineHttpBO.setStatus(updateServiceDefineReqBO.getStatus());
                serviceDefineHttpBO.setServiceAddress(updateServiceDefineReqBO.getHttpConfig().getServiceAddress());
                serviceDefineHttpBO.setRequestType(updateServiceDefineReqBO.getHttpConfig().getRequestType());
                JSONObject reqCodeFormatJSONObject = updateServiceDefineReqBO.getHttpConfig().getReqCodeFormat();
                serviceDefineHttpBO.setReqCodeFormat(reqCodeFormatJSONObject == null ? null : reqCodeFormatJSONObject.toString());
                JSONObject rspCodeFormatJSONObject = updateServiceDefineReqBO.getHttpConfig().getRspCodeFormat();
                serviceDefineHttpBO.setRspCodeFormat(rspCodeFormatJSONObject == null ? null : rspCodeFormatJSONObject.toString());
                this.httpServiceConfigDAO.updateByServiceId(serviceDefineHttpBO);
                this.updateZkHttpServiceDefine(serviceId, serviceDefinePO, serviceDefineHttpBO);
                break;
            }
            case HSF: {
                ServiceDefineHsfBO serviceDefineHsfBO = updateServiceDefineReqBO.getHsfConfig();
                serviceDefineHsfBO.setServiceId(serviceId);
                this.hsfServiceConfigDAO.updateByServiceId(serviceDefineHsfBO);
                this.updateZkHsfServiceDefine(serviceId, serviceDefinePO, serviceDefineHsfBO);
                break;
            }
            case PYTHON: {
                ServiceDefinePythonBO serviceDefinePythonBO = updateServiceDefineReqBO.getPythonConfig();
                serviceDefinePythonBO.setServiceId(serviceId);
                this.pythonServiceConfigDAO.updateByServiceId(serviceDefinePythonBO);
                this.updateZkPythonServiceDefine(serviceId, serviceDefinePO, serviceDefinePythonBO);
                break;
            }
            case SHELL: {
                ServiceDefineShellBO serviceDefineShellBO = updateServiceDefineReqBO.getShellConfig();
                serviceDefineShellBO.setServiceId(serviceId);
                this.shellServiceConfigDAO.updateByServiceId(serviceDefineShellBO);
                this.updateZkShellServiceDefine(serviceId, serviceDefinePO, serviceDefineShellBO);
                break;
            }
            case MQ: {
                ServiceDefineMqBO serviceDefineMqBO = updateServiceDefineReqBO.getMqConfig();
                serviceDefineMqBO.setServiceId(serviceId);
                this.mqServiceConfigDAO.updateServiceId(serviceDefineMqBO);
                this.updateZkMQServiceDefine(serviceId, serviceDefinePO, serviceDefineMqBO);
                break;
            }
            default: {
                throw new IllegalArgumentException("the serviceTypeEnum not exist.");
            }
        }
        RspInfoBO rspInfoBO = new RspInfoBO();
        rspInfoBO.setRespCode(TMSConfigResponseCodeEnum.SUCCESS.getErrorCode());
        return rspInfoBO;
    }

    private void updateZkMQServiceDefine(Long serviceId, ServiceDefinePO serviceDefinePO, ServiceDefineMqBO serviceDefineMqRspBO) {
        ZkServiceDefineBO zkServiceDefineBO = (ZkServiceDefineBO)this.mapper.map((Object)serviceDefinePO, ZkServiceDefineBO.class);
        ZkMqServiceConfigBO zkMqServiceConfigBO = (ZkMqServiceConfigBO)this.mapper.map((Object)serviceDefineMqRspBO, ZkMqServiceConfigBO.class);
        zkServiceDefineBO.setMqConfig(zkMqServiceConfigBO);
        this.zkClient.updateData(serviceId.toString(), JSONObject.toJSONString((Object)zkServiceDefineBO), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
    }

    private void updateZkShellServiceDefine(Long serviceId, ServiceDefinePO serviceDefinePO, ServiceDefineShellBO serviceDefineShellRspBO) {
        ZkServiceDefineBO zkServiceDefineBO = (ZkServiceDefineBO)this.mapper.map((Object)serviceDefinePO, ZkServiceDefineBO.class);
        ZkShellServiceConfigBO zkShellServiceConfigBO = (ZkShellServiceConfigBO)this.mapper.map((Object)serviceDefineShellRspBO, ZkShellServiceConfigBO.class);
        zkServiceDefineBO.setShellConfig(zkShellServiceConfigBO);
        this.zkClient.updateData(serviceId.toString(), JSONObject.toJSONString((Object)zkServiceDefineBO), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
    }

    private void updateZkPythonServiceDefine(Long serviceId, ServiceDefinePO serviceDefinePO, ServiceDefinePythonBO serviceDefinePythonRspBO) {
        ZkServiceDefineBO zkServiceDefineBO = (ZkServiceDefineBO)this.mapper.map((Object)serviceDefinePO, ZkServiceDefineBO.class);
        ZkPythonServiceConfigBO zkPythonServiceConfigBO = (ZkPythonServiceConfigBO)this.mapper.map((Object)serviceDefinePythonRspBO, ZkPythonServiceConfigBO.class);
        zkServiceDefineBO.setPythonConfig(zkPythonServiceConfigBO);
        this.zkClient.updateData(serviceId.toString(), JSONObject.toJSONString((Object)zkServiceDefineBO), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
    }

    private void updateZkHsfServiceDefine(Long serviceId, ServiceDefinePO serviceDefinePO, ServiceDefineHsfBO serviceDefineHsfRspBO) {
        ZkServiceDefineBO zkServiceDefineBO = (ZkServiceDefineBO)this.mapper.map((Object)serviceDefinePO, ZkServiceDefineBO.class);
        ZkHsfServiceConfigBO zkHsfServiceConfigBO = (ZkHsfServiceConfigBO)this.mapper.map((Object)serviceDefineHsfRspBO, ZkHsfServiceConfigBO.class);
        zkServiceDefineBO.setHsfConfig(zkHsfServiceConfigBO);
        this.zkClient.updateData(serviceId.toString(), JSONObject.toJSONString((Object)zkServiceDefineBO), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
    }

    private void updateZkHttpServiceDefine(Long serviceId, ServiceDefinePO serviceDefinePO, ServiceDefineHttpBO serviceDefineHttpRspBO) {
        ZkServiceDefineBO zkServiceDefineBO = (ZkServiceDefineBO)this.mapper.map((Object)serviceDefinePO, ZkServiceDefineBO.class);
        ZkHttpServiceConfigBO zkHttpServiceConfigBO = (ZkHttpServiceConfigBO)this.mapper.map((Object)serviceDefineHttpRspBO, ZkHttpServiceConfigBO.class);
        zkServiceDefineBO.setHttpConfig(zkHttpServiceConfigBO);
        this.zkClient.updateData(serviceId.toString(), JSONObject.toJSONString((Object)zkServiceDefineBO), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
    }
}

