/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.bo.RspInfoBO;
import com.ohaotian.task.timing.bo.UpdateServiceDefineStatusReqBO;
import com.ohaotian.task.timing.bo.ZkServiceDefineBO;
import com.ohaotian.task.timing.dao.BatchTaskDAO;
import com.ohaotian.task.timing.dao.BusinessDefineDAO;
import com.ohaotian.task.timing.dao.JobExecutionLogDAO;
import com.ohaotian.task.timing.dao.RtTaskDefineDAO;
import com.ohaotian.task.timing.dao.ServiceDefineDAO;
import com.ohaotian.task.timing.dao.po.BusinessDefinePO;
import com.ohaotian.task.timing.dao.po.RtTaskDefinePO;
import com.ohaotian.task.timing.enums.ServiceStatusEnum;
import com.ohaotian.task.timing.enums.TMSConfigResponseCodeEnum;
import com.ohaotian.task.timing.exception.TMSConfigException;
import com.ohaotian.task.timing.service.UpdateServiceDefineStatusService;
import com.ohaotian.task.timing.utils.ZookeeperClient;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateServiceDefineStatusServiceImpl
implements UpdateServiceDefineStatusService {
    private static final Logger log = LoggerFactory.getLogger(UpdateServiceDefineStatusServiceImpl.class);
    @Autowired
    private ServiceDefineDAO serviceDefineDAO;
    @Autowired
    private BatchTaskDAO batchTaskDAO;
    @Autowired
    private BusinessDefineDAO businessDefineDAO;
    @Autowired
    private JobExecutionLogDAO jobExecutionLogDAO;
    @Autowired
    private RtTaskDefineDAO rtTaskDefineDAO;
    @Autowired
    private ZookeeperClient zkClient;

    @Override
    public RspInfoBO updateServiceDefineStatus(UpdateServiceDefineStatusReqBO updateServiceDefineStatusReqBO) {
        String originJson;
        Long serviceId = updateServiceDefineStatusReqBO.getServiceId();
        Integer status = updateServiceDefineStatusReqBO.getStatus();
        ServiceStatusEnum serviceStatusEnum = ServiceStatusEnum.codeOf(updateServiceDefineStatusReqBO.getStatus());
        if (serviceStatusEnum == null) {
            log.warn("\u751f\u5931\u6548\u670d\u52a1\uff0cstatus \u9519\u8bef\uff0cserviceId: {}, status\uff1a{}", (Object)serviceId, (Object)status);
            throw new TMSConfigException(TMSConfigResponseCodeEnum.PARAM_ERROR);
        }
        RtTaskDefinePO taskDefinePO = this.rtTaskDefineDAO.queryServiceIdBeUsedValidRecord(serviceId);
        if (taskDefinePO != null) {
            log.warn("\u8be5\u670d\u52a1\u5df2\u88ab\u751f\u6548\u7684\u5b9e\u65f6\u4efb\u52a1\u5b9a\u4e49\u5f15\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff0cserviceId: {}", (Object)serviceId);
            throw new TMSConfigException(TMSConfigResponseCodeEnum.SERVICE_BE_VALID_REAL_TASK_DEFINE_REFERENCED);
        }
        BusinessDefinePO businessDefinePO = this.businessDefineDAO.queryServiceIdBeUsedValidRecord(serviceId);
        if (businessDefinePO != null) {
            log.warn("\u8be5\u670d\u52a1\u5df2\u88ab\u751f\u6548\u7684\u5b9a\u65f6\u4efb\u52a1\u5b9a\u4e49\u5f15\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u6216\u5931\u6548\u64cd\u4f5c\uff0cserviceId: {}", (Object)serviceId);
            throw new TMSConfigException(TMSConfigResponseCodeEnum.SERVICE_BE_VALID_TIMING_TASK_DEFINE_REFERENCED);
        }
        int count = this.serviceDefineDAO.updateStatusByServiceId(updateServiceDefineStatusReqBO);
        if (count > 0 && StringUtils.isNotBlank((String)(originJson = this.zkClient.getData(serviceId.toString(), ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE)))) {
            ZkServiceDefineBO zkServiceDefineBO = (ZkServiceDefineBO)JSONObject.parseObject((String)originJson, ZkServiceDefineBO.class);
            zkServiceDefineBO.setStatus(status);
            String newJson = JSONObject.toJSONString((Object)zkServiceDefineBO);
            this.zkClient.updateData(serviceId.toString(), newJson, ZookeeperClient.NodeTypeEnum.SERVICE_DEFINE);
        }
        RspInfoBO rspInfoBO = new RspInfoBO();
        rspInfoBO.setRespCode(TMSConfigResponseCodeEnum.SUCCESS.getErrorCode());
        return rspInfoBO;
    }
}

