/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.JobType;
import com.dangdang.ddframe.job.lite.lifecycle.api.JobSettingsAPI;
import com.dangdang.ddframe.job.lite.lifecycle.domain.JobSettings;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.ohaotian.task.timing.core.constant.Consts;
import com.ohaotian.task.timing.core.service.IJobManageService;
import com.ohaotian.task.timing.core.service.JobAPIService;
import com.ohaotian.task.timing.core.service.RegistryCenterService;
import com.ohaotian.task.timing.dao.BusinessDefineDAO;
import com.ohaotian.task.timing.dao.HsfServiceConfigDAO;
import com.ohaotian.task.timing.dao.HttpServiceConfigDAO;
import com.ohaotian.task.timing.dao.MqServiceConfigDAO;
import com.ohaotian.task.timing.dao.PythonServiceConfigDAO;
import com.ohaotian.task.timing.dao.ServiceDefineDAO;
import com.ohaotian.task.timing.dao.ShellServiceConfigDAO;
import com.ohaotian.task.timing.dao.po.BusinessDefinePO;
import com.ohaotian.task.timing.dao.po.HsfServiceConfigPO;
import com.ohaotian.task.timing.dao.po.HttpServiceConfigPO;
import com.ohaotian.task.timing.dao.po.JobPO;
import com.ohaotian.task.timing.dao.po.MqServiceConfigPO;
import com.ohaotian.task.timing.dao.po.PythonServiceConfigPO;
import com.ohaotian.task.timing.dao.po.ServiceDefinePO;
import com.ohaotian.task.timing.dao.po.ShellServiceConfigPO;
import com.ohaotian.task.timing.service.IZKJobService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZKJobServiceImpl
implements IZKJobService {
    private static final Logger log = LogManager.getLogger(ZKJobServiceImpl.class);
    @Autowired
    private IJobManageService iJobManageService;
    @Autowired
    private JobAPIService jobAPIService;
    @Autowired
    private RegistryCenterService registryCenterService;
    @Autowired
    private BusinessDefineDAO businessDefineDAO;
    @Autowired
    private ServiceDefineDAO serviceDefineDAO;
    @Autowired
    private HttpServiceConfigDAO httpServiceConfigDAO;
    @Autowired
    private HsfServiceConfigDAO hsfServiceConfigDAO;
    @Autowired
    private MqServiceConfigDAO mqServiceConfigDAO;
    @Autowired
    private ShellServiceConfigDAO shellServiceConfigDAO;
    @Autowired
    private PythonServiceConfigDAO pythonServiceConfigDAO;
    @Value(value="${timedtask.delaysecond}")
    private int delaySecond = 30;

    @Override
    public int addTimedTask(Long businessId) {
        JobSettings jobSettings = this.buildJobSettingsByBusinessId(businessId);
        return this.iJobManageService.addTimedTask(jobSettings);
    }

    @Override
    public int updateTimedTask(Long businessId) {
        JobSettings jobSettings = this.buildJobSettingsByBusinessId(businessId);
        return this.iJobManageService.updateTimedTask(jobSettings);
    }

    @Override
    public int saveOrUpdateTimedTask(Long businessId) {
        JobSettings jobSettings = this.buildJobSettingsByBusinessId(businessId);
        return this.iJobManageService.saveOrUpdateTimedTask(jobSettings);
    }

    @Override
    public int removeTimedTask(Long businessId) {
        BusinessDefinePO definePO = this.getBusinessPoByBusinessId(businessId);
        String jobName = definePO.getUserGroupId() + "_" + definePO.getBusinessName();
        return this.iJobManageService.removeTimedTask(jobName);
    }

    @Override
    public int removeTimedTaskByJobName(String jobName) {
        return this.iJobManageService.removeTimedTask(jobName);
    }

    @Override
    public int refreshTimedTask() {
        List<BusinessDefinePO> businessPoList = this.selectBusinessPoWhenIsTimedTask();
        CoordinatorRegistryCenter registryCenter = this.registryCenterService.getRegistryCenter();
        List childrenKeys = registryCenter.getChildrenKeys("/%_Metadata_Storage_%");
        JobSettingsAPI jobSettingsAPI = this.jobAPIService.getJobSettingsAPI();
        childrenKeys.stream().map(arg_0 -> ((JobSettingsAPI)jobSettingsAPI).getJobSettings(arg_0)).filter(this::isTimedTask).map(JobSettings::getJobName).forEach(this::removeTimedTaskByJobName);
        businessPoList.stream().map(BusinessDefinePO::getBusinessId).forEach(this::addTimedTask);
        return 1;
    }

    private JobSettings buildJobSettingsByBusinessId(Long businessId) {
        BusinessDefinePO definePO = this.getBusinessPoByBusinessId(businessId);
        JobPO jobPO = new JobPO();
        String jobName = definePO.getUserGroupId() + "_" + definePO.getBusinessName();
        jobPO.setJobName(jobName);
        jobPO.setDescription(definePO.getBusinessDesc());
        jobPO.setCron(definePO.getCronExpression());
        jobPO.setShardingItemParameters(definePO.getSplitRule());
        jobPO.setShardingTotalCount(definePO.getSplitTotal());
        JobSettings jobSettings = new JobSettings();
        BeanUtils.copyProperties((Object)jobPO, (Object)jobSettings);
        Long serviceId = definePO.getServiceId();
        ServiceDefinePO serviceDefinePO = this.getServiceDefinePoByServiceId(serviceId);
        if ("1".equals(serviceDefinePO.getServiceType().toString())) {
            jobSettings.setJobClass("com.ohaotian.task.timing.lite.jobs.HttpTimedTaskJob");
            jobSettings.setJobType(JobType.SIMPLE.name());
            HttpServiceConfigPO httpServiceConfPO = this.getHttpServiceConfPO(serviceId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("HTTP_PARAM", (Object)definePO.getBusinessPara());
            jsonObject.put("HTTP_SERVER_ADDRESS", (Object)httpServiceConfPO.getServiceAddress());
            jsonObject.put("HTTP_METHOD", (Object)httpServiceConfPO.getRequestType());
            jsonObject.put("BUSINESS_ID", (Object)businessId);
            jsonObject.put("IS_RETRY", (Object)definePO.getIsRetry());
            jsonObject.put("TIMEOUT", (Object)definePO.getTimeout());
            jsonObject.put("RETRY_COUNT", (Object)definePO.getRetryCount());
            jobSettings.setJobParameter(jsonObject.toJSONString());
            return jobSettings;
        }
        if ("3".equals(serviceDefinePO.getServiceType().toString())) {
            jobSettings.setJobClass("com.ohaotian.task.timing.lite.jobs.HSFTimedTaskJob");
            jobSettings.setJobType(JobType.SIMPLE.name());
            HsfServiceConfigPO hsfServiceConfPO = this.getHsfServiceConfPO(serviceId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("HSF_PARAM", (Object)definePO.getBusinessPara());
            jsonObject.put("HSF_SERVICE_NAME", (Object)hsfServiceConfPO.getServiceName());
            jsonObject.put("HSF_METHOD", (Object)hsfServiceConfPO.getMethodName());
            jsonObject.put("HSF_VERSION", (Object)hsfServiceConfPO.getVersionNo());
            jsonObject.put("HSF_GROUP", (Object)hsfServiceConfPO.getGroupName());
            jsonObject.put("HSF_TIME_OUT", (Object)hsfServiceConfPO.getTimeOut());
            jsonObject.put("HSF_PARAM_TYPE", (Object)hsfServiceConfPO.getParamType());
            jsonObject.put("BUSINESS_ID", (Object)businessId);
            jobSettings.setJobParameter(jsonObject.toJSONString());
            return jobSettings;
        }
        if ("6".equals(serviceDefinePO.getServiceType().toString())) {
            jobSettings.setJobClass("com.ohaotian.task.timing.lite.jobs.MQTimedTaskJob");
            jobSettings.setJobType(JobType.SIMPLE.name());
            MqServiceConfigPO mqServiceConfPO = this.getMqServiceConfPO(serviceId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("MQ_PARAM", (Object)definePO.getBusinessPara());
            jsonObject.put("MQ_ADDRESS", (Object)mqServiceConfPO.getMqAddress());
            jsonObject.put("MQ_TAG", (Object)mqServiceConfPO.getMqTag());
            jsonObject.put("MQ_TOPIC", (Object)mqServiceConfPO.getMqTopic());
            jsonObject.put("MQ_PID", (Object)mqServiceConfPO.getMqPid());
            jsonObject.put("ACCESS_KEY", (Object)mqServiceConfPO.getAccessKey());
            jsonObject.put("SECRET_KEY", (Object)mqServiceConfPO.getSecretKey());
            jsonObject.put("MQ_OBJECT_CLASS", (Object)mqServiceConfPO.getObjectClass());
            jsonObject.put("BUSINESS_ID", (Object)businessId);
            jobSettings.setJobParameter(jsonObject.toJSONString());
            return jobSettings;
        }
        if ("5".equals(serviceDefinePO.getServiceType().toString())) {
            jobSettings.setJobClass("com.ohaotian.task.timing.lite.jobs.ShellTimedTaskJob");
            jobSettings.setJobType(JobType.SIMPLE.name());
            ShellServiceConfigPO shellServiceDefinePO = this.getShellServiceConfPO(serviceId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("SHELL_PARAM", (Object)definePO.getBusinessPara());
            jsonObject.put("SHELL_HOST", (Object)shellServiceDefinePO.getShellHost());
            jsonObject.put("SHELL_PORT", (Object)shellServiceDefinePO.getShellPort());
            jsonObject.put("SHELL_USER_NAME", (Object)shellServiceDefinePO.getShellUserName());
            jsonObject.put("SHELL_PASSWORD", (Object)shellServiceDefinePO.getShellPassword());
            jsonObject.put("SHELL_ADDRESS", (Object)shellServiceDefinePO.getShellAddress());
            jsonObject.put("SHELL_ENCODING", (Object)shellServiceDefinePO.getShellEncoding());
            jsonObject.put("BUSINESS_ID", (Object)businessId);
            jsonObject.put("TIMEOUT", (Object)definePO.getTimeout());
            jsonObject.put("IS_RETRY", (Object)definePO.getIsRetry());
            jsonObject.put("RETRY_COUNT", (Object)definePO.getRetryCount());
            jobSettings.setJobParameter(jsonObject.toJSONString());
            return jobSettings;
        }
        if ("4".equals(serviceDefinePO.getServiceType().toString())) {
            jobSettings.setJobClass("com.ohaotian.task.timing.lite.jobs.PythonTimedTaskJob");
            jobSettings.setJobType(JobType.SIMPLE.name());
            PythonServiceConfigPO pythonServiceConfPO = this.getPythonServiceConfPO(serviceId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("PYTHON_PARAM", (Object)definePO.getBusinessPara());
            jsonObject.put("PYTHON_HOST", (Object)pythonServiceConfPO.getPythonHost());
            jsonObject.put("PYTHON_PORT", (Object)pythonServiceConfPO.getPythonPort());
            jsonObject.put("PYTHON_USER_NAME", (Object)pythonServiceConfPO.getPythonUserName());
            jsonObject.put("PYTHON_PASSWORD", (Object)pythonServiceConfPO.getPythonPassword());
            jsonObject.put("PYTHON_ADDRESS", (Object)pythonServiceConfPO.getPythonAddress());
            jsonObject.put("PYTHON_ENCODING", (Object)pythonServiceConfPO.getPythonEncoding());
            jsonObject.put("PYTHON_VERSION", (Object)pythonServiceConfPO.getPythonVersion());
            jsonObject.put("BUSINESS_ID", (Object)businessId);
            jsonObject.put("TIMEOUT", (Object)definePO.getTimeout());
            jsonObject.put("IS_RETRY", (Object)definePO.getIsRetry());
            jsonObject.put("RETRY_COUNT", (Object)definePO.getRetryCount());
            jobSettings.setJobParameter(jsonObject.toJSONString());
            return jobSettings;
        }
        return jobSettings;
    }

    private boolean isTimedTask(JobSettings jobSettings) {
        return Consts.TIMED_TASKS.contains(jobSettings.getJobClass());
    }

    private boolean isExisted(String jobName) {
        CoordinatorRegistryCenter registryCenter = this.registryCenterService.getRegistryCenter();
        String key = "/%_Metadata_Storage_%/" + jobName;
        return registryCenter.isExisted(key);
    }

    private List<BusinessDefinePO> selectBusinessPoWhenIsTimedTask() {
        return this.businessDefineDAO.selectByBusinessType("1");
    }

    private BusinessDefinePO getBusinessPoByBusinessId(Long businessId) {
        return this.businessDefineDAO.selectByPrimaryKey(businessId);
    }

    private ServiceDefinePO getServiceDefinePoByServiceId(Long serviceId) {
        return this.serviceDefineDAO.selectByPrimaryKey(serviceId);
    }

    private HttpServiceConfigPO getHttpServiceConfPO(Long serviceId) {
        return this.httpServiceConfigDAO.selectByServiceId(serviceId);
    }

    private HsfServiceConfigPO getHsfServiceConfPO(Long serviceId) {
        return this.hsfServiceConfigDAO.selectByServiceId(serviceId);
    }

    private MqServiceConfigPO getMqServiceConfPO(Long serviceId) {
        return this.mqServiceConfigDAO.selectByServiceId(serviceId);
    }

    private ShellServiceConfigPO getShellServiceConfPO(Long serviceId) {
        return this.shellServiceConfigDAO.selectByServiceId(serviceId);
    }

    private PythonServiceConfigPO getPythonServiceConfPO(Long serviceId) {
        return this.pythonServiceConfigDAO.selectByServiceId(serviceId);
    }
}

