/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.utils;

import com.ohaotian.task.timing.core.config.RegistryCenterProperties;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ZookeeperClient {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperClient.class);
    @Autowired
    private RegistryCenterProperties registryCenterProperties;
    @Autowired
    private CuratorFramework zkClient;

    public String getData(String nodeName, NodeTypeEnum nodeTypeEnum) {
        switch (nodeTypeEnum) {
            case TOPIC_CONFIG: {
                return this.getNodeData(this.registryCenterProperties.getTopicNode() + "/" + nodeName);
            }
            case SERVICE_DEFINE: {
                return this.getNodeData(this.registryCenterProperties.getTaskDefineNode() + "/" + nodeName);
            }
        }
        throw new IllegalArgumentException("the nodeTypeEnum can not null");
    }

    public void setData(String nodeName, String nodeData, NodeTypeEnum nodeTypeEnum) {
        switch (nodeTypeEnum) {
            case TOPIC_CONFIG: {
                this.createNode(this.registryCenterProperties.getTopicNode() + "/" + nodeName, nodeData);
                break;
            }
            case SERVICE_DEFINE: {
                this.createNode(this.registryCenterProperties.getTaskDefineNode() + "/" + nodeName, nodeData);
                break;
            }
            default: {
                throw new IllegalArgumentException("the nodeTypeEnum can not null");
            }
        }
    }

    public void updateData(String nodeName, String nodeData, NodeTypeEnum nodeTypeEnum) {
        switch (nodeTypeEnum) {
            case TOPIC_CONFIG: {
                this.updateNode(this.registryCenterProperties.getTopicNode() + "/" + nodeName, nodeData);
                break;
            }
            case SERVICE_DEFINE: {
                this.updateNode(this.registryCenterProperties.getTaskDefineNode() + "/" + nodeName, nodeData);
                break;
            }
            default: {
                throw new IllegalArgumentException("the nodeTypeEnum can not null");
            }
        }
    }

    public void deleteNode(String nodeName, NodeTypeEnum nodeTypeEnum) {
        switch (nodeTypeEnum) {
            case TOPIC_CONFIG: {
                this.deleteNode(this.registryCenterProperties.getTopicNode() + "/" + nodeName);
                break;
            }
            case SERVICE_DEFINE: {
                this.deleteNode(this.registryCenterProperties.getTaskDefineNode() + "/" + nodeName);
                break;
            }
            default: {
                throw new IllegalArgumentException("the nodeTypeEnum can not null");
            }
        }
    }

    public void createNode(String node, String nodeData) {
        try {
            this.zkClient.create().creatingParentContainersIfNeeded().forPath(node, nodeData.getBytes());
        }
        catch (Exception e) {
            log.error("ZookeeperClient.createNode ==> node: {}, nodeData: {}", new Object[]{node, nodeData, e});
        }
    }

    public void updateNode(String node, String nodeData) {
        try {
            this.zkClient.setData().forPath(node, nodeData.getBytes());
        }
        catch (Exception e) {
            log.error("ZookeeperClient.updateNode ==> node: {}, nodeData: {}", new Object[]{node, nodeData, e});
        }
    }

    public void deleteNode(String node) {
        try {
            this.zkClient.delete().forPath(node);
        }
        catch (Exception e) {
            log.error("ZookeeperClient.deleteNode ==> node: {}", (Object)node, (Object)e);
        }
    }

    public String getNodeData(String node) {
        try {
            byte[] bytes = (byte[])this.zkClient.getData().forPath(node);
            if (bytes != null && bytes.length > 0) {
                return new String(bytes);
            }
        }
        catch (Exception e) {
            log.error("ZookeeperClient.getNodeData ==> node: {}", (Object)node, (Object)e);
        }
        return null;
    }

    public static enum NodeTypeEnum {
        TOPIC_CONFIG,
        SERVICE_DEFINE;

    }
}

