/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.web;

import com.dangdang.ddframe.job.event.rdb.JobEventRdbSearch;
import com.google.common.base.Strings;
import com.ohaotian.task.timing.core.service.RegistryCenterService;
import com.ohaotian.task.timing.model.JsonModel;
import com.ohaotian.task.timing.model.RowsModel;
import com.ohaotian.task.timing.searcher.JobExecutionSearcher;
import com.ohaotian.task.timing.searcher.JobStatusTraceSearcher;
import java.util.Date;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/timing/config/event-trace"})
public class EventTraceHistoryRestfulController {
    private static final Logger log = LogManager.getLogger(EventTraceHistoryRestfulController.class);
    @Autowired
    private RegistryCenterService registryCenterService;

    @PostMapping(value={"/execution"})
    public JsonModel<RowsModel> findJobExecutionEvents(JobExecutionSearcher searcher) {
        JobEventRdbSearch jobEventRdbSearch = new JobEventRdbSearch(this.registryCenterService.getDataSource());
        JobEventRdbSearch.Result result = jobEventRdbSearch.findJobExecutionEvents(this.buildJobExecutionCondition(searcher));
        return JsonModel.success(new RowsModel(result.getRows(), result.getTotal(), searcher.getPageNo()));
    }

    private JobEventRdbSearch.Condition buildJobExecutionCondition(JobExecutionSearcher searcher) {
        int perPage = searcher.getPageSize();
        int page = searcher.getPageNo();
        String sort = searcher.getSort();
        String order = searcher.getOrder();
        Date startTime = searcher.getStartTime();
        Date endTime = searcher.getEndTime();
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (!Strings.isNullOrEmpty((String)searcher.getJobName())) {
            result.put("jobName", searcher.getJobName());
        }
        if (!Strings.isNullOrEmpty((String)searcher.getIp())) {
            result.put("ip", searcher.getIp());
        }
        if (!Strings.isNullOrEmpty((String)searcher.getIsSuccess())) {
            result.put("isSuccess", searcher.getIsSuccess());
        }
        return new JobEventRdbSearch.Condition(perPage, page, sort, order, startTime, endTime, result);
    }

    @PostMapping(value={"/status"})
    public JsonModel<RowsModel> findJobStatusTraceEvents(JobStatusTraceSearcher searcher) {
        JobEventRdbSearch jobEventRdbSearch = new JobEventRdbSearch(this.registryCenterService.getDataSource());
        JobEventRdbSearch.Result result = jobEventRdbSearch.findJobStatusTraceEvents(this.buildJobStatusCondition(searcher));
        return JsonModel.success(new RowsModel(result.getRows(), result.getTotal(), searcher.getPageNo()));
    }

    private JobEventRdbSearch.Condition buildJobStatusCondition(JobStatusTraceSearcher searcher) {
        int perPage = searcher.getPageSize();
        int page = searcher.getPageNo();
        String sort = searcher.getSort();
        String order = searcher.getOrder();
        Date startTime = searcher.getStartTime();
        Date endTime = searcher.getEndTime();
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (!Strings.isNullOrEmpty((String)searcher.getJobName())) {
            result.put("jobName", searcher.getJobName());
        }
        if (!Strings.isNullOrEmpty((String)searcher.getSource())) {
            result.put("source", searcher.getSource());
        }
        if (!Strings.isNullOrEmpty((String)searcher.getExecutionType())) {
            result.put("executionType", searcher.getExecutionType());
        }
        if (!Strings.isNullOrEmpty((String)searcher.getState())) {
            result.put("state", searcher.getState());
        }
        return new JobEventRdbSearch.Condition(perPage, page, sort, order, startTime, endTime, result);
    }
}

