/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.web;

import com.google.common.base.Optional;
import com.ohaotian.task.timing.core.service.JobAPIService;
import com.ohaotian.task.timing.model.JsonModel;
import com.ohaotian.task.timing.model.RowsModel;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/timing/config/jobs"})
public class JobOperationRestfulController {
    private static final Logger log = LogManager.getLogger(JobOperationRestfulController.class);
    @Autowired
    private JobAPIService jobAPIService;

    @PostMapping(value={"/count"})
    public JsonModel<Integer> getJobsTotalCount() {
        return JsonModel.success(this.jobAPIService.getJobStatisticsAPI().getJobsTotalCount());
    }

    @PostMapping(value={"/infos"})
    public JsonModel<RowsModel> getAllJobsBriefInfo() {
        Collection jobBriefInfos = this.jobAPIService.getJobStatisticsAPI().getAllJobsBriefInfo();
        return JsonModel.success(new RowsModel(jobBriefInfos));
    }

    @PostMapping(value={"/{jobName}/trigger"})
    public JsonModel triggerJob(@PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().trigger(Optional.of((Object)jobName), Optional.absent());
        return JsonModel.success();
    }

    @PostMapping(value={"/{jobName}/disable"})
    public JsonModel disableJob(@PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().disable(Optional.of((Object)jobName), Optional.absent());
        return JsonModel.success();
    }

    @PostMapping(value={"/{jobName}/enable"})
    public JsonModel enableJob(@PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().enable(Optional.of((Object)jobName), Optional.absent());
        return JsonModel.success();
    }

    @PostMapping(value={"/{jobName}/shutdown"})
    public JsonModel shutdownJob(@PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().shutdown(Optional.of((Object)jobName), Optional.absent());
        return JsonModel.success();
    }

    @PostMapping(value={"/{jobName}/shardinginfos"})
    public JsonModel<RowsModel> getShardingInfo(@PathVariable(value="jobName") String jobName) {
        Collection shardingInfos = this.jobAPIService.getShardingStatisticsAPI().getShardingInfo(jobName);
        return JsonModel.success(new RowsModel(shardingInfos));
    }

    @PostMapping(value={"/{jobName}/sharding/{item}/disable"})
    public JsonModel disableSharding(@PathVariable(value="jobName") String jobName, @PathVariable(value="item") String item) {
        this.jobAPIService.getShardingOperateAPI().disable(jobName, item);
        return JsonModel.success();
    }

    @PostMapping(value={"/{jobName}/sharding/{item}/enable"})
    public JsonModel enableSharding(@PathVariable(value="jobName") String jobName, @PathVariable(value="item") String item) {
        this.jobAPIService.getShardingOperateAPI().enable(jobName, item);
        return JsonModel.success();
    }
}

