/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.web;

import com.dangdang.ddframe.job.lite.lifecycle.domain.JobSettings;
import com.google.gson.Gson;
import com.ohaotian.task.timing.dao.po.JobPO;
import com.ohaotian.task.timing.exception.ProjectException;
import com.ohaotian.task.timing.model.JsonModel;
import com.ohaotian.task.timing.service.JobSettingsService;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/timing/config/job-config"})
public class LiteJobConfigRestfulController {
    private static final Logger log = LogManager.getLogger(LiteJobConfigRestfulController.class);
    private static Gson gson = new Gson();
    @Autowired
    private JobSettingsService jobSettingsService;

    @PostMapping(value={"/add"})
    public JsonModel addHttpTimedTask(@RequestBody JobPO jobPO) {
        log.traceEntry("addTimedTask(JobVo)", new Object[]{jobPO});
        try {
            if (this.jobSettingsService.isExisted(jobPO.getJobName())) {
                return JsonModel.fail("\u65b0\u589e\u5931\u8d25:\u76f8\u540c\u540d\u79f0\u7684Job\u5df2\u7ecf\u5b58\u5728!");
            }
            JobSettings jobSettings = new JobSettings();
            BeanUtils.copyProperties((Object)jobPO, (Object)jobSettings);
            this.jobSettingsService.addJob(jobSettings);
        }
        catch (ProjectException ex) {
            return JsonModel.fail(ex.getMessage());
        }
        return JsonModel.success("\u65b0\u589e\u6210\u529f!");
    }

    public JsonModel addHttpRealTimeTask(@RequestBody JobPO jobPO) {
        log.traceEntry("addRealTimeTask(JobPO)", new Object[]{jobPO});
        try {
            if (this.jobSettingsService.isExisted(jobPO.getJobName())) {
                return JsonModel.fail("\u65b0\u589e\u5931\u8d25:\u76f8\u540c\u540d\u79f0\u7684Job\u5df2\u7ecf\u5b58\u5728!");
            }
            JobSettings jobSettings = new JobSettings();
            BeanUtils.copyProperties((Object)jobPO, (Object)jobSettings);
            this.jobSettingsService.addJob(jobSettings);
        }
        catch (ProjectException ex) {
            return JsonModel.fail(ex.getMessage());
        }
        return JsonModel.success("\u65b0\u589e\u6210\u529f!");
    }

    @PostMapping(value={"/{jobName}/remove"})
    public JsonModel removeJob(@PathVariable(value="jobName") String jobName) {
        log.traceEntry("removeJob(String)", new Object[]{jobName});
        try {
            this.jobSettingsService.removeJob(jobName);
        }
        catch (ProjectException ex) {
            return JsonModel.fail(ex.getMessage());
        }
        return JsonModel.success("\u5220\u9664\u6210\u529f!");
    }

    @PostMapping(value={"/updateJob"})
    public JsonModel updateJob(@RequestBody JobPO jobPO) {
        Optional<JobSettings> optJobJobSettings = this.jobSettingsService.getJob(jobPO.getJobName());
        if (!optJobJobSettings.isPresent()) {
            return JsonModel.fail("\u66f4\u65b0\u5931\u8d25:\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a" + jobPO.getJobName() + "\u7684Job!");
        }
        JobSettings jobSettings = optJobJobSettings.get();
        BeanUtils.copyProperties((Object)jobPO, (Object)jobSettings, (String[])new String[]{"jobName", "jobType", "jobClass"});
        try {
            this.jobSettingsService.updateJob(jobSettings);
        }
        catch (ProjectException ex) {
            return JsonModel.fail(ex.getMessage());
        }
        return JsonModel.success("\u66f4\u65b0\u6210\u529f!");
    }

    @PostMapping(value={"/{jobName}/get"})
    public JsonModel<JobPO> getJob(@PathVariable(value="jobName") String jobName) {
        Optional<JobSettings> optJobJobSettings = this.jobSettingsService.getJob(jobName);
        JobSettings settings = optJobJobSettings.get();
        if (optJobJobSettings.isPresent()) {
            JobSettings jobSettings = optJobJobSettings.get();
            JobPO jobPO = new JobPO();
            BeanUtils.copyProperties((Object)jobSettings, (Object)jobPO);
            return JsonModel.success(jobPO);
        }
        return JsonModel.fail("\u67e5\u8be2\u5931\u8d25:\u5bf9\u5e94\u540d\u79f0\u7684Job\u4e0d\u5b58\u5728!");
    }
}

