/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.web;

import com.google.common.base.Optional;
import com.ohaotian.task.timing.bo.ServerManageBO;
import com.ohaotian.task.timing.core.service.JobAPIService;
import com.ohaotian.task.timing.model.JsonModel;
import com.ohaotian.task.timing.model.RowsModel;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/timing/config/serversManage"})
public class ServerOperationManageController {
    private static final Logger log = LogManager.getLogger(ServerOperationManageController.class);
    @Autowired
    private JobAPIService jobAPIService;

    @PostMapping(value={"/infos"})
    public JsonModel<RowsModel> getAllServersBriefInfo() {
        Collection serverBriefInfos = this.jobAPIService.getServerStatisticsAPI().getAllServersBriefInfo();
        return JsonModel.success(new RowsModel(serverBriefInfos));
    }

    @PostMapping(value={"/serverIp/jobinfos"})
    public JsonModel getJobs(@RequestBody ServerManageBO serverManageBO) {
        log.debug("=====" + serverManageBO);
        Collection jobBriefInfos = this.jobAPIService.getJobStatisticsAPI().getJobsBriefInfo(serverManageBO.getServerIp());
        return JsonModel.success(new RowsModel(jobBriefInfos));
    }

    @PostMapping(value={"/serverIp/disable"})
    public JsonModel disableServer(@RequestBody ServerManageBO serverManageBO) {
        this.jobAPIService.getJobOperatorAPI().disable(Optional.absent(), Optional.of((Object)serverManageBO.getServerIp()));
        return JsonModel.success();
    }

    @PostMapping(value={"/serverIp/enable"})
    public JsonModel enableServer(@RequestBody ServerManageBO serverManageBO) {
        this.jobAPIService.getJobOperatorAPI().enable(Optional.absent(), Optional.of((Object)serverManageBO.getServerIp()));
        return JsonModel.success();
    }

    @PostMapping(value={"/serverIp/shutdown"})
    public JsonModel shutdownServer(@RequestBody String serverIp) {
        this.jobAPIService.getJobOperatorAPI().shutdown(Optional.absent(), Optional.of((Object)serverIp));
        return JsonModel.success();
    }
}

