/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.web;

import com.google.common.base.Optional;
import com.ohaotian.task.timing.core.service.JobAPIService;
import com.ohaotian.task.timing.model.JsonModel;
import com.ohaotian.task.timing.model.RowsModel;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/timing/config/servers"})
public class ServerOperationRestfulController {
    private static final Logger log = LogManager.getLogger(ServerOperationRestfulController.class);
    @Autowired
    private JobAPIService jobAPIService;

    @PostMapping(value={"/count"})
    public JsonModel<Integer> getServersTotalCount() {
        return JsonModel.success(this.jobAPIService.getServerStatisticsAPI().getServersTotalCount());
    }

    @PostMapping(value={"/infos"})
    public JsonModel<RowsModel> getAllServersBriefInfo() {
        Collection serverBriefInfos = this.jobAPIService.getServerStatisticsAPI().getAllServersBriefInfo();
        return JsonModel.success(new RowsModel(serverBriefInfos));
    }

    @PostMapping(value={"/{serverIp}/disable"})
    public JsonModel disableServer(@PathVariable(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().disable(Optional.absent(), Optional.of((Object)serverIp));
        return JsonModel.success();
    }

    @PostMapping(value={"/{serverIp}/enable"})
    public JsonModel enableServer(@PathVariable(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().enable(Optional.absent(), Optional.of((Object)serverIp));
        return JsonModel.success();
    }

    @PostMapping(value={"/{serverIp}/shutdown"})
    public JsonModel shutdownServer(@PathVariable(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().shutdown(Optional.absent(), Optional.of((Object)serverIp));
        return JsonModel.success();
    }

    @PostMapping(value={"/{serverIp}/remove"})
    public JsonModel removeServer(@PathVariable(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().remove(Optional.absent(), Optional.of((Object)serverIp));
        return JsonModel.success();
    }

    @PostMapping(value={"/{serverIp}/jobinfos"})
    public JsonModel getJobs(@PathVariable(value="serverIp") String serverIp) {
        Collection jobBriefInfos = this.jobAPIService.getJobStatisticsAPI().getJobsBriefInfo(serverIp);
        return JsonModel.success(new RowsModel(jobBriefInfos));
    }

    @PostMapping(value={"/{serverIp}/jobs/{jobName}/disable"})
    public JsonModel disableServerJob(@PathVariable(value="serverIp") String serverIp, @PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().disable(Optional.of((Object)jobName), Optional.of((Object)serverIp));
        return JsonModel.success();
    }

    @PostMapping(value={"/{serverIp}/jobs/{jobName}/enable"})
    public JsonModel enableServerJob(@PathVariable(value="serverIp") String serverIp, @PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().enable(Optional.of((Object)jobName), Optional.of((Object)serverIp));
        return JsonModel.success();
    }

    @PostMapping(value={"/{serverIp}/jobs/{jobName}/shutdown"})
    public JsonModel shutdownServerJob(@PathVariable(value="serverIp") String serverIp, @PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().shutdown(Optional.of((Object)jobName), Optional.of((Object)serverIp));
        return JsonModel.success();
    }

    @PostMapping(value={"/{serverIp}/jobs/{jobName}/remove"})
    public JsonModel removeServerJob(@PathVariable(value="serverIp") String serverIp, @PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().remove(Optional.of((Object)jobName), Optional.of((Object)serverIp));
        return JsonModel.success();
    }
}

