/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.web;

import com.google.common.base.Optional;
import com.ohaotian.plugin.base.bo.RspInfoBO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.task.timing.bo.BusinessDefineReqBO;
import com.ohaotian.task.timing.bo.BusinessDefineReqPageBO;
import com.ohaotian.task.timing.bo.BusinessDefineRspBO;
import com.ohaotian.task.timing.bo.BusinessDefineRspPageBO;
import com.ohaotian.task.timing.core.service.JobAPIService;
import com.ohaotian.task.timing.service.BusinessDefineService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/timing/config/taskBusinessDefine"})
public class TaskBusinessDefineController {
    private static final Logger log = LogManager.getLogger(TaskBusinessDefineController.class);
    @Autowired
    private BusinessDefineService businessDefineService;
    @Autowired
    private JobAPIService jobAPIService;

    @RequestMapping(value={"/addTimeTask"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"}, maxAge=3600L)
    public BusinessDefineRspBO addTimeTask(@RequestBody BusinessDefineReqBO reqBO) {
        BusinessDefineRspBO rsp = this.businessDefineService.addTimeTask(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/updateBusi"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"}, maxAge=3600L)
    public BusinessDefineRspBO updateTimedTask(@RequestBody BusinessDefineReqBO reqBO) {
        BusinessDefineRspBO businessDefineRspBO = this.businessDefineService.updateTimeTask(reqBO);
        return businessDefineRspBO;
    }

    @RequestMapping(value={"/deleteBusi"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"}, maxAge=3600L)
    public RspInfoBO deleteTimedTask(@RequestBody BusinessDefineReqBO reqBO) {
        RspInfoBO rspInfoBO = this.businessDefineService.deleteTimeTask(reqBO);
        return rspInfoBO;
    }

    @RequestMapping(value={"/selectDetail"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"}, maxAge=3600L)
    public void selectDetail(@RequestBody BusinessDefineReqPageBO reqBO) {
        this.businessDefineService.queryTimeTask(reqBO);
    }

    @RequestMapping(value={"/queryTimeTask"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"}, maxAge=3600L)
    public RspPageBO<BusinessDefineRspPageBO> queryTimeTask(@RequestBody BusinessDefineReqPageBO reqBO) {
        RspPageBO<BusinessDefineRspPageBO> businessDefineRspPageBORspPageBO = this.businessDefineService.queryTimeTask(reqBO);
        return businessDefineRspPageBORspPageBO;
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"}, maxAge=3600L)
    public BusinessDefineRspPageBO queryById(@RequestBody BusinessDefineReqBO reqBO) {
        BusinessDefineRspPageBO businessDefineRspPageBO = this.businessDefineService.queryById(reqBO);
        return businessDefineRspPageBO;
    }

    @RequestMapping(value={"/timeTrigger"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"}, maxAge=3600L)
    public BusinessDefineRspPageBO timeTrigger(@RequestBody BusinessDefineReqBO reqBO) {
        log.debug("\u5b9a\u65f6\u4efb\u52a1\u89e6\u53d1\u4f5c\u4e1a\u89e6\u53d1\u5165\u53c2" + (Object)((Object)reqBO));
        BusinessDefineRspPageBO rsp = new BusinessDefineRspPageBO();
        try {
            String jobName = reqBO.getUserGroupId() + "_" + reqBO.getBusinessName();
            this.jobAPIService.getJobOperatorAPI().trigger(Optional.of((Object)jobName), Optional.absent());
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u89e6\u53d1\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u89e6\u53d1\u5931\u8d25");
        }
        return rsp;
    }

    @RequestMapping(value={"/shardingItemTimeTrigger"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"}, maxAge=3600L)
    public RspInfoBO shardingItemTimeTrigger(@RequestBody BusinessDefineReqBO reqBO) {
        log.debug("\u5b9a\u65f6\u4efb\u52a1\u5206\u7247\u89e6\u53d1\u4f5c\u4e1a\u5165\u53c2" + (Object)((Object)reqBO));
        RspInfoBO rsp = new RspInfoBO();
        rsp = this.businessDefineService.triggerShardingItem(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"}, maxAge=3600L)
    public RspInfoBO timeUpdateStatus(@RequestBody BusinessDefineReqBO businessDefineReqBO) {
        RspInfoBO rsp = this.businessDefineService.updateTimeStatus(businessDefineReqBO);
        return rsp;
    }
}

